/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.lampad;

import com.ovinter.mythsandlegends.entity.LampadEntity;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FindLightSourceGoal
extends Goal {
    private final LampadEntity mob;
    private final int searchRadius;
    private BlockPos targetLightPos;

    public FindLightSourceGoal(LampadEntity mob, int searchRadius) {
        this.mob = mob;
        this.searchRadius = searchRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.f_19797_ % 20 != 0) {
            return false;
        }
        this.targetLightPos = this.findNearestLight();
        return this.targetLightPos != null;
    }

    public void m_8056_() {
        if (this.targetLightPos != null) {
            this.mob.m_21573_().m_26519_((double)this.targetLightPos.m_123341_(), (double)this.targetLightPos.m_123342_(), (double)this.targetLightPos.m_123343_(), 1.0);
        }
    }

    public void m_8037_() {
        if (this.targetLightPos != null) {
            this.mob.m_21563_().m_8128_();
            this.mob.m_21563_().m_24946_((double)this.targetLightPos.m_123341_(), (double)this.targetLightPos.m_123342_(), (double)this.targetLightPos.m_123343_());
            if (this.mob.m_20238_(Vec3.m_82512_((Vec3i)this.targetLightPos)) < 2.0) {
                this.destroyLight();
            }
        }
    }

    private void destroyLight() {
        Level level = this.mob.m_9236_();
        if (level.m_8055_(this.targetLightPos).getLightEmission((BlockGetter)level, this.targetLightPos) > 0) {
            level.m_46961_(this.targetLightPos, true);
            this.applyStatBoost();
            this.targetLightPos = null;
        }
    }

    private BlockPos findNearestLight() {
        BlockPos mobPos = this.mob.m_20183_();
        Level level = this.mob.m_9236_();
        for (BlockPos pos : BlockPos.m_121925_((BlockPos)mobPos, (int)this.searchRadius, (int)this.searchRadius, (int)this.searchRadius)) {
            if (level.m_7146_(pos) <= 0 || level.m_8055_(pos).getLightEmission((BlockGetter)level, pos) <= 0) continue;
            return pos;
        }
        return null;
    }

    private void applyStatBoost() {
        AttributeInstance damageAttr;
        CompoundTag data = this.mob.getPersistentData();
        int boosts = data.m_128451_("StatBoosts");
        data.m_128405_("StatBoosts", ++boosts);
        UUID healthUUID = UUID.nameUUIDFromBytes(("health_boost_" + boosts).getBytes());
        UUID damageUUID = UUID.nameUUIDFromBytes(("damage_boost_" + boosts).getBytes());
        AttributeInstance healthAttr = this.mob.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            healthAttr.m_22125_(new AttributeModifier(healthUUID, "light_destroy_health_boost", 0.1 * (double)boosts, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((damageAttr = this.mob.m_21051_(Attributes.f_22281_)) != null) {
            damageAttr.m_22125_(new AttributeModifier(damageUUID, "light_destroy_damage_boost", 0.1 * (double)boosts, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.mob.m_5496_(SoundEvents.f_11868_, 1.0f, 2.0f);
        this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)69);
        this.mob.m_21153_(this.mob.m_21233_());
    }
}

