/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ImpaleAttackGoal
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private int attackTicks;
    private final int ATTACK_DURATION = 60;

    public ImpaleAttackGoal(PossessedArmorInquisitorEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.target.m_6084_() && this.mob.getAnimationId() == 0 && (double)this.mob.m_217043_().m_188501_() <= 0.14 && this.mob.m_142582_((Entity)this.target) && this.mob.m_20096_() && this.mob.impaleCooldown <= 0 && !this.mob.m_21224_();
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.mob.impaleCooldown <= 0;
    }

    public void m_8056_() {
        this.mob.setAnimationId(this.mob.IMPALE);
        this.mob.m_21573_().m_26573_();
        this.attackTicks = 0;
    }

    public void m_8037_() {
        ++this.attackTicks;
        if (this.target == null) {
            return;
        }
        this.mob.m_21563_().m_148051_((Entity)this.target);
        this.mob.m_21563_().m_8128_();
        if (this.attackTicks == 35) {
            Player player;
            ItemStack stack;
            Vec3 mobPos = this.mob.m_20182_();
            Vec3 targetPos = this.target.m_20182_();
            double distanceX = targetPos.f_82479_ - mobPos.f_82479_;
            double distanceZ = targetPos.f_82481_ - mobPos.f_82481_;
            float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
            this.mob.m_146922_(yaw);
            this.mob.m_5618_(yaw);
            this.mob.m_5616_(yaw);
            Vec3 direction = targetPos.m_82546_(mobPos).m_82541_();
            Vec3 newMobPos = targetPos.m_82546_(direction.m_82490_(0.8));
            Vec3 dashVector = direction.m_82490_(1.2);
            this.mob.m_20334_(dashVector.f_82479_, 0.0, dashVector.f_82481_);
            this.mob.f_19812_ = true;
            this.mob.m_6034_(newMobPos.f_82479_, newMobPos.f_82480_, newMobPos.f_82481_);
            Vec3 pushForward = direction.m_82490_(1.5);
            this.spawnSonicBoomParticles(this.target);
            this.mob.m_9236_().m_5594_(null, this.mob.m_20183_(), (SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (stack = (player = (Player)livingEntity).m_21211_()).m_41720_() instanceof ShieldItem) {
                player.m_36335_().m_41524_(stack.m_41720_(), 100);
            }
            this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 12.0f);
            this.target.m_5997_(pushForward.f_82479_, 0.3, pushForward.f_82481_);
        }
        if (this.attackTicks >= 60) {
            this.m_8041_();
        }
    }

    public void m_8041_() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.mob.impaleCooldown = this.mob.IMPALE_COOLDOWN;
        this.attackTicks = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    private void spawnSonicBoomParticles(LivingEntity target) {
        Level level = this.mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 start = this.mob.m_20182_().m_82520_(0.0, (double)this.mob.m_20206_() * 0.5, 0.0);
        Vec3 end = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 direction = end.m_82546_(start);
        int steps = 20;
        for (int i = 0; i < steps; ++i) {
            Vec3 pos = start.m_82549_(direction.m_82490_((double)i / (double)steps));
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)MLParticles.AIR_BURST_PARTICLE.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

