/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.gargoyle;

import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class GargoyleFollowOwnerGoal
extends Goal {
    private final GargoyleEntity mob;
    @Nullable
    private LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public GargoyleFollowOwnerGoal(GargoyleEntity pMob, double speedModifier, float startDistance, float stopDistance) {
        this.mob = pMob;
        this.speedModifier = speedModifier;
        this.navigation = pMob.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(pMob.m_21573_() instanceof GroundPathNavigation) && !(pMob.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (this.mob.unableToMoveToOwner()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return this.mob.unableToMoveToOwner() ? false : !(this.mob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        boolean flag = this.mob.shouldTryTeleportToOwner();
        if (!flag) {
            this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (flag) {
                this.mob.tryToTeleportToOwner();
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

