/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.amarok;

import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AmarokEntity;
import com.ovinter.mythsandlegends.entity.projectile.FrostSpikeEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BackStepAttackGoal
extends Goal {
    private final AmarokEntity mob;
    private LivingEntity target;
    private final List<Entity> floatingProjectiles = new ArrayList<Entity>();
    private int attackTick;
    private int projectileIndex;
    private final int ATTACK_DURATION = 80;
    private final int TOTAL_PROJECTILES = 3;
    private final int SHOOT_INTERVAL = 25;

    public BackStepAttackGoal(AmarokEntity pMob) {
        this.mob = pMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.mob.getAnimationId() == 0 && this.mob.m_6084_() && this.mob.m_20096_() && this.mob.rangedCooldown == 0;
    }

    public boolean m_8045_() {
        return this.mob.m_6084_() && this.projectileIndex < 3;
    }

    public void m_8056_() {
        this.mob.setAnimationId(this.mob.BACKSTEP_JUMP);
        this.attackTick = 0;
        this.projectileIndex = 0;
    }

    public void m_8041_() {
        this.target = null;
        this.floatingProjectiles.clear();
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.projectileIndex = 0;
        this.mob.rangedCooldown = DefaultMobAttributes.AMAROK_RANGED_COOLDOWN;
    }

    public void m_8037_() {
        ++this.attackTick;
        if (this.target == null) {
            return;
        }
        if (this.attackTick > 80) {
            this.m_8041_();
        }
        this.applyBodyRot();
        if (this.attackTick == 10) {
            this.pushBackwards();
        }
        if (this.attackTick >= 11 && this.attackTick <= 80) {
            this.tryToFreezeWaterUnderneath();
        }
        if (this.attackTick == 20) {
            this.spawnFloatingProjectiles();
            this.mob.setAnimationId(2);
        }
        if (this.attackTick % 25 == 0 && this.projectileIndex < this.floatingProjectiles.size()) {
            this.shootProjectile(this.floatingProjectiles.get(this.projectileIndex));
            ++this.projectileIndex;
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void applyBodyRot() {
        Vec3 mobPos = this.mob.m_20182_();
        Vec3 targetPos = this.target.m_20182_();
        double distanceX = targetPos.f_82479_ - mobPos.f_82479_;
        double distanceZ = targetPos.f_82481_ - mobPos.f_82481_;
        float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
        this.mob.m_146922_(yaw);
        this.mob.m_5618_(yaw);
        this.mob.m_5616_(yaw);
    }

    private void pushBackwards() {
        Vec3 look = this.mob.m_20154_();
        this.mob.m_20256_(this.mob.m_20184_().m_82520_(-look.f_82479_ * 0.8, 0.5, -look.f_82481_ * 0.8));
        this.mob.m_21573_().m_26573_();
    }

    private void spawnFloatingProjectiles() {
        for (int i = 0; i < 3; ++i) {
            FrostSpikeEntity spike = new FrostSpikeEntity((EntityType<? extends FrostSpikeEntity>)((EntityType)MLEntities.FROST_SPIKE.get()), this.mob.m_9236_());
            double y = this.mob.m_20186_() + (i == 1 ? (double)this.mob.m_20192_() + 2.5 : (double)this.mob.m_20192_() + 1.5);
            spike.m_6034_(this.mob.m_20185_() + (double)i, y, this.mob.m_20189_());
            spike.m_20242_(true);
            spike.m_20334_(0.0, 0.0, 0.0);
            spike.setTarget(this.target);
            this.mob.m_9236_().m_7967_((Entity)spike);
            this.floatingProjectiles.add((Entity)spike);
        }
    }

    private void shootProjectile(Entity p) {
        if (!(p instanceof FrostSpikeEntity)) {
            return;
        }
        FrostSpikeEntity spike = (FrostSpikeEntity)p;
        if (this.target == null) {
            return;
        }
        spike.m_20242_(false);
        Vec3 dir = this.target.m_20182_().m_82546_(spike.m_20182_()).m_82541_().m_82490_(1.25);
        spike.m_20334_(dir.f_82479_, dir.f_82480_ + 0.12, dir.f_82481_);
    }

    private void tryToFreezeWaterUnderneath() {
        BlockPos posBelow = this.mob.m_20183_().m_7495_();
        if (this.mob.m_20069_() || this.mob.m_9236_().m_8055_(posBelow).m_60734_() == Blocks.f_49990_) {
            int radius = 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos freezePos = posBelow.m_7918_(x, 0, z);
                    if (this.mob.m_9236_().m_8055_(freezePos).m_60734_() != Blocks.f_49990_) continue;
                    this.mob.m_9236_().m_7731_(freezePos, Blocks.f_50449_.m_49966_(), 3);
                }
            }
        }
    }
}

