/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.abaddon;

import com.ovinter.mythsandlegends.entity.AbaddonEntity;
import com.ovinter.mythsandlegends.entity.effects.MoltenThornEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoltenSpikesGoal
extends Goal {
    private final AbaddonEntity mob;
    private LivingEntity target;
    private int attackTick;
    private final int ATTACK_DURATION = 30;
    private final int TOTAL_SPIKES = 6;
    private final double[] rowAngles = new double[]{-27.0, 0.0, 27.0};

    public MoltenSpikesGoal(AbaddonEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.mob.getAnimationId() == 0 && this.mob.m_20270_((Entity)this.target) <= 6.0f && this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20072_() && this.mob.m_6084_() && this.mob.moltenSpikeCooldown == 0;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.mob.moltenSpikeCooldown == 0;
    }

    public void m_8056_() {
        this.mob.setAnimationId(2);
        this.mob.m_21573_().m_26573_();
        this.mob.m_21563_().m_148051_((Entity)this.target);
        this.attackTick = 0;
    }

    public void m_8041_() {
        this.mob.setAnimationId(0);
        this.mob.m_21573_().m_26569_();
        this.attackTick = 0;
        this.mob.moltenSpikeCooldown = this.mob.MOLTEN_SPIKE_COOLDOWN;
    }

    public void m_8037_() {
        ++this.attackTick;
        this.mob.m_21563_().m_148051_((Entity)this.target);
        this.mob.m_21563_().m_8128_();
        if (this.target != null && this.attackTick == 15) {
            Vec3 mobPos = this.mob.m_20182_();
            Vec3 targetPos = this.target.m_20182_();
            double distanceX = targetPos.f_82479_ - mobPos.f_82479_;
            double distanceZ = targetPos.f_82481_ - mobPos.f_82481_;
            float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
            this.mob.m_146922_(yaw);
            this.mob.m_5618_(yaw);
            this.mob.m_5616_(yaw);
            for (double rowAngle : this.rowAngles) {
                for (int i = 0; i < 6; ++i) {
                    this.spawnMoltenSpikes(i, this.mob, rowAngle);
                }
            }
        }
        if (this.attackTick >= 30) {
            this.m_8041_();
        }
    }

    private void spawnMoltenSpikes(int pIndex, AbaddonEntity abaddon, double pAngleOffset) {
        int lowestYCheck = Mth.m_14107_((double)abaddon.m_20186_()) - 1;
        double y = abaddon.m_20186_() + 1.0;
        float yawRadians = (float)Math.toRadians((double)(90.0f + abaddon.m_146908_()) + pAngleOffset);
        double distance = 2.0 + (double)pIndex * 1.25;
        int warmUpDelayTicks = pIndex * 2;
        double x = abaddon.m_20185_() + (double)Mth.m_14089_((float)yawRadians) * distance;
        double z = abaddon.m_20189_() + (double)Mth.m_14031_((float)yawRadians) * distance;
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean foundGround = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos blockPos1 = blockPos.m_7495_();
            BlockState blockState = abaddon.m_9236_().m_8055_(blockPos1);
            if (!blockState.m_60783_((BlockGetter)abaddon.m_9236_(), blockPos1, Direction.UP)) continue;
            if (!abaddon.m_9236_().m_46859_(blockPos) && !(voxelShape = (blockState1 = abaddon.m_9236_().m_8055_(blockPos)).m_60812_((BlockGetter)abaddon.m_9236_(), blockPos)).m_83281_()) {
                d0 = voxelShape.m_83297_(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= lowestYCheck);
        if (foundGround) {
            MoltenThornEntity thornEntity = new MoltenThornEntity(abaddon.m_9236_(), x, (double)blockPos.m_123342_() + d0, z, yawRadians, warmUpDelayTicks, 4.0f, (LivingEntity)abaddon);
            abaddon.m_9236_().m_7967_((Entity)thornEntity);
        }
    }
}

