/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.IgnisNexusEntity;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.effects.EffectScreenShake;
import com.ovinter.mythsandlegends.entity.effects.MoltenThornEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WarbornAegisEntity
extends MLEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation ATTACK2 = RawAnimation.begin().thenPlay("ATTACK2");
    private static final RawAnimation ATTACK3 = RawAnimation.begin().thenPlay("ATTACK_COMBO");
    private static final RawAnimation SHIELD_ATTACK = RawAnimation.begin().thenPlay("SHIELD_ATTACK");
    private static final RawAnimation START_JUMP = RawAnimation.begin().thenPlay("START_JUMP");
    private static final RawAnimation METEOR_JUMP = RawAnimation.begin().thenLoop("JUMP");
    private static final RawAnimation KICK_ATTACK = RawAnimation.begin().thenPlay("KICK");
    private static final RawAnimation INFERNAL = RawAnimation.begin().thenPlay("INFERNAL_THORNS");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> LANDING_TICK = SynchedEntityData.m_135353_(WarbornAegisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final List<UUID> ignisNexusUUIDs = new ArrayList<UUID>();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private float healthPercentage;
    public static final int START_METEOR_SLAM = 2;
    public static final int METEOR_SLAM = 3;
    public static final int SHIELD_STAMPEDE = 4;
    public static final int KICK = 5;
    public static final int SINGLE_ATTACK = 6;
    public static final int SINGLE_ATTACK_ALT = 7;
    public static final int ATTACK_COMBO = 8;
    public static int meteorCooldown = DefaultMobAttributes.WARBORN_AEGIS_METEOR_COOLDOWN;
    public static int stampedeCooldown = DefaultMobAttributes.WARBORN_AEGIS_STAMPEDE_COOLDOWN;
    public static int kickCooldown = DefaultMobAttributes.WARBORN_AEGIS_KICK_COOLDOWN;
    public static int singleAttackCooldown = DefaultMobAttributes.WARBORN_AEGIS_COMBO_COOLDOWN;
    public static int comboCooldown = DefaultMobAttributes.WARBORN_AEGIS_COMBO_COOLDOWN;
    public boolean isEnraged;
    public int rageTimer;
    public int attacktick;

    public WarbornAegisEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.f_21364_ = 150;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.WARBORN_AEGIS_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.WARBORN_AEGIS_ARMOR).m_22268_(Attributes.f_22285_, DefaultMobAttributes.WARBORN_AEGIS_ARMOR_TOUGHNESS).m_22268_(Attributes.f_22281_, DefaultMobAttributes.WARBORN_AEGIS_ATTACK_DAMAGE).m_22268_(Attributes.f_22283_, DefaultMobAttributes.WARBORN_AEGIS_ATTACK_SPEED).m_22268_(Attributes.f_22279_, DefaultMobAttributes.WARBORN_AEGIS_MOVEMENT).m_22268_(Attributes.f_22278_, DefaultMobAttributes.WARBORN_AEGIS_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.WARBORN_AEGIS_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new ComboAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LANDING_TICK, (Object)20);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag nexusList = new ListTag();
        for (UUID uuid : this.ignisNexusUUIDs) {
            nexusList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        pCompound.m_128365_("IgnisNexuses", (Tag)nexusList);
        pCompound.m_128405_("LandingTick", this.getLandingTick());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ListTag nexusList = pCompound.m_128437_("IgnisNexuses", 11);
        for (int i = 0; i < nexusList.size(); ++i) {
            this.ignisNexusUUIDs.add(NbtUtils.m_129233_((Tag)nexusList.get(i)));
        }
        this.f_19804_.m_135381_(LANDING_TICK, (Object)pCompound.m_128451_("LandingTick"));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.getAnimationId() == 4 || this.rageTimer > 0 || this.isEnraged && this.getActiveNexusCount() > 0) {
            return false;
        }
        if (this.healthPercentage <= 0.3f && !this.isEnraged) {
            this.activateRageMode();
        }
        if (pSource.m_276093_(DamageTypes.f_268493_) || pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        int nexusCount = this.getActiveNexusCount();
        float reducedDamage = pAmount * (1.0f - (float)nexusCount * 0.1f);
        return super.m_6469_(pSource, reducedDamage);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean success = super.m_7327_(pEntity);
        if (success && pEntity instanceof LivingEntity) {
            this.playAttackSound();
        }
        return success;
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (!this.m_9236_().f_46443_) {
            for (UUID nexusUUID : new ArrayList<UUID>(this.ignisNexusUUIDs)) {
                Entity nexus = ((ServerLevel)this.m_9236_()).m_8791_(nexusUUID);
                if (!(nexus instanceof IgnisNexusEntity)) continue;
                nexus.m_146870_();
            }
            this.ignisNexusUUIDs.clear();
        }
        super.m_6667_(pDamageSource);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_203441_(FluidState pFluidState) {
        return pFluidState.m_205070_(FluidTags.f_13132_);
    }

    public float m_21692_(BlockPos pPos) {
        if (this.m_9236_().m_8055_(pPos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return super.m_21692_(pPos);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        this.m_20101_();
        if (this.m_20077_()) {
            this.m_183634_();
        } else {
            super.m_7840_(pY, pOnGround, pState, pPos);
        }
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            ParticleGeneratorHelper.generateChargeParticles(this.m_9236_(), (Entity)this);
        }
        if (id == 68) {
            ParticleGeneratorHelper.generateFallingParticles(this.m_9236_(), (LivingEntity)this);
        }
        if (id == 69) {
            ParticleGeneratorHelper.generateChargeParticles(this.m_9236_(), (Entity)this);
        }
        if (id == 70) {
            ParticleGeneratorHelper.generateStompParticles(this.m_9236_(), (LivingEntity)this);
        }
        if (id == 71) {
            ParticleGeneratorHelper.generateLandingParticles(this.m_9236_(), (LivingEntity)this);
        }
        if (id <= 0) {
            this.setLandingTick(20);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.healthPercentage = this.m_21223_() / this.m_21233_();
        if (this.attacktick == 0) {
            ++this.attacktick;
        }
        if (this.isEnraged && this.rageTimer > 0) {
            --this.rageTimer;
        }
        if (stampedeCooldown > 0) {
            --stampedeCooldown;
        }
        if (meteorCooldown > 0) {
            --meteorCooldown;
        }
        if (kickCooldown > 0) {
            --kickCooldown;
        }
        if (comboCooldown > 0) {
            --comboCooldown;
        }
        if (singleAttackCooldown > 0) {
            --singleAttackCooldown;
        }
        if (this.getLandingTick() > 0 && meteorCooldown == 0) {
            this.setLandingTick((Integer)this.f_19804_.m_135370_(LANDING_TICK) - 1);
        }
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.healthPercentage);
        this.setAttackTicks(this.getAttackTicks() - 1);
        super.m_8024_();
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.rageTimer > 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public void m_6457_(ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        this.bossEvent.m_6543_(pServerPlayer);
    }

    public void m_6452_(ServerPlayer pServerPlayer) {
        super.m_6452_(pServerPlayer);
        this.bossEvent.m_6539_(pServerPlayer);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8032_() {
        this.m_216990_((SoundEvent)MLSounds.WARBORN_AEGIS_AMBIENT.get());
    }

    protected void m_6677_(DamageSource pSource) {
        this.m_216990_((SoundEvent)MLSounds.WARBORN_AEGIS_HURT.get());
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.WARBORN_AEGIS_DEATH.get();
    }

    protected void playAttackSound() {
        this.m_216990_((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.get());
    }

    @Override
    public void setAnimationId(int id) {
        super.setAnimationId(id);
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void setLandingTick(int tick) {
        this.m_20088_().m_135381_(LANDING_TICK, (Object)tick);
    }

    public int getLandingTick() {
        return (Integer)this.m_20088_().m_135370_(LANDING_TICK);
    }

    private double getCurrentDamage() {
        return this.m_21133_(Attributes.f_22281_);
    }

    private double getCurrentSpeed() {
        return this.m_21133_(Attributes.f_22279_);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            state.setAndContinue(DEATH);
        } else if (this.getAnimationId() == 2 && this.m_20096_() && this.getLandingTick() > 0) {
            state.setAndContinue(START_JUMP);
        } else if (this.getAnimationId() == 3 && !this.m_20096_()) {
            state.setAndContinue(METEOR_JUMP);
        } else if (this.getAnimationId() == 4) {
            state.setAndContinue(SHIELD_ATTACK);
        } else if (this.getAnimationId() == 5 && this.m_20096_()) {
            state.setAndContinue(KICK_ATTACK);
        } else if (state.isMoving()) {
            state.setAndContinue(WALK);
        } else {
            state.setAndContinue(IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == 8) {
            state.getController().forceAnimationReset();
            state.setAndContinue(ATTACK3);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.WARBORN_AEGIS_STEP.get(), SoundSource.HOSTILE, 0.4f, 1.0f, false);
            }
        }).triggerableAnim("rageAnim", RAGE)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
    }

    private void activateRageMode() {
        if (this.isEnraged) {
            return;
        }
        EffectScreenShake.ScreenShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.2f, 20, 10);
        this.isEnraged = true;
        this.rageTimer = 30;
        this.triggerAnim("controller", "rageAnim");
        AttributeInstance speedAttr = this.m_21051_(Attributes.f_22279_);
        speedAttr.m_22118_(new AttributeModifier("RageSpeedBoost", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL));
        AttributeInstance damageAttr = this.m_21051_(Attributes.f_22281_);
        damageAttr.m_22118_(new AttributeModifier("RageDamageBoost", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.m_5496_((SoundEvent)MLSounds.WARBORN_AEGIS_RAGE.get(), 2.0f, 1.0f);
    }

    private void spawnInfernalThorns(double x, double z, double minY, double maxY, float yRot, int warmupDelay) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new MoltenThornEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, yRot, warmupDelay, 2.0f, (LivingEntity)this));
        }
    }

    private void spawnIgnisNexus() {
        if (!this.m_9236_().f_46443_ && this.getActiveNexusCount() < 3) {
            BlockPos groundPos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.m_20183_());
            IgnisNexusEntity nexus = new IgnisNexusEntity(this.m_9236_(), this.m_20148_());
            nexus.m_6034_((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_() + 0.5, (double)groundPos.m_123343_() + 0.5);
            this.m_9236_().m_7967_((Entity)nexus);
            this.ignisNexusUUIDs.add(nexus.m_20148_());
        }
    }

    public void onNexusDestroyed(UUID nexusUUID) {
        this.ignisNexusUUIDs.remove(nexusUUID);
    }

    private int getActiveNexusCount() {
        if (this.m_9236_().f_46443_) {
            return 0;
        }
        int count = 0;
        Iterator<UUID> iterator = this.ignisNexusUUIDs.iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
            if (entity instanceof IgnisNexusEntity && entity.m_6084_()) {
                ++count;
                continue;
            }
            iterator.remove();
        }
        return count;
    }

    public void performComboAttack(double fanAngle, double fanDistance) {
        Vec3 position = this.m_20182_();
        Vec3 forward = this.m_20154_().m_82541_();
        Vec3 horizontalForward = new Vec3(forward.f_82479_, 0.0, forward.f_82481_);
        if (horizontalForward.m_82556_() > 0.0) {
            horizontalForward = horizontalForward.m_82541_();
        }
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(fanDistance), e -> e != this);
        for (LivingEntity target : nearbyEntities) {
            Player player;
            Vec3 toTarget = target.m_20182_().m_82546_(position);
            Vec3 horizontalToTarget = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_);
            if (horizontalToTarget.m_82556_() > 0.0) {
                horizontalToTarget = horizontalToTarget.m_82541_();
            }
            double distanceToTarget = target.m_20182_().m_82554_(position);
            double dotProduct = horizontalForward.m_82526_(horizontalToTarget);
            double clampedDotProduct = Mth.m_14008_((double)dotProduct, (double)-1.0, (double)1.0);
            double angleBetween = Math.acos(clampedDotProduct) * 57.29577951308232;
            if (!(angleBetween <= fanAngle / 2.0) || !(distanceToTarget <= fanDistance) || target instanceof WarbornAegisEntity) continue;
            boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (!(target instanceof Player) || (player = (Player)target).m_21254_()) continue;
            target.f_19802_ = 0;
            if (!flag) continue;
            this.m_5496_((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.get(), 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
        }
    }

    public static class ComboAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int comboStage;
        private int attackTick;
        private static final int[] ATTACK_TIMES = new int[]{8, 24};

        public ComboAttackGoal(WarbornAegisEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (!((double)this.mob.m_20270_((Entity)this.target) <= 3.0)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.m_217043_().m_188501_();
            float f2 = this.mob.isEnraged ? 0.2f : 0.15f;
            if (!(f <= f2)) return false;
            if (!this.mob.m_20096_()) return false;
            if (comboCooldown > 0) return false;
            return true;
        }

        public void m_8056_() {
            this.mob.setAnimationId(8);
            this.comboStage = 0;
            this.attackTick = 0;
            this.mob.m_21563_().m_148051_((Entity)this.target);
        }

        public void m_8037_() {
            ++this.attackTick;
            if (this.target == null || !this.target.m_6084_()) {
                this.m_8041_();
                return;
            }
            this.mob.m_21563_().m_148051_((Entity)this.target);
            if (this.comboStage < ATTACK_TIMES.length && this.attackTick >= ATTACK_TIMES[this.comboStage]) {
                this.mob.performComboAttack(100.0, 3.5);
                ++this.comboStage;
            }
            if (this.attackTick >= 30) {
                this.m_8041_();
            }
        }

        public void m_8041_() {
            this.mob.setAnimationId(0);
            this.comboStage = 0;
            this.attackTick = 0;
            comboCooldown = 80;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && comboCooldown <= 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class SingleAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int attackTick;

        public SingleAttackGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.getAnimationId() == 6;
        }

        public void m_8056_() {
            this.mob.setAnimationId(6);
            this.attackTick = 0;
        }

        public void m_8041_() {
            this.mob.setAnimationId(0);
            this.target = null;
            this.attackTick = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.mob.attacktick < 20;
        }

        public void m_8037_() {
            ++this.attackTick;
            if (this.target != null) {
                this.mob.m_21563_().m_8128_();
                this.mob.m_21563_().m_24960_((Entity)this.target, 90.0f, 90.0f);
                if (this.attackTick == 17) {
                    float f1 = (float)Math.cos(Math.toRadians(this.mob.m_146908_() + 90.0f));
                    float f2 = (float)Math.sin(Math.toRadians(this.mob.m_146908_() + 90.0f));
                    this.mob.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
                }
                if (this.attackTick == 17) {
                    this.mob.performComboAttack(100.0, 3.5);
                    this.mob.m_5496_((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.get(), 3.0f, 0.5f + this.mob.m_217043_().m_188501_() * 0.1f);
                }
                this.mob.m_21573_().m_26569_();
            }
        }
    }

    public static class KickAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        LivingEntity target;
        private int kickTimer;

        public KickAttackGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (!((double)this.mob.m_20270_((Entity)this.target) <= 2.0)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.m_217043_().m_188501_();
            float f2 = this.mob.isEnraged ? 0.14f : 0.1f;
            if (!(f <= f2)) return false;
            if (kickCooldown > 0) return false;
            if (!this.mob.m_20096_()) return false;
            return true;
        }

        public void m_8056_() {
            this.mob.setAnimationId(5);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            ++this.kickTimer;
            if (this.kickTimer == 10) {
                this.performKick();
            }
            if (this.kickTimer == 15) {
                this.m_8041_();
            }
        }

        private void performKick() {
            float damage = (float)this.mob.getCurrentDamage();
            double deltaX = this.target.m_20185_() - this.mob.m_20185_();
            double deltaZ = this.target.m_20189_() - this.mob.m_20189_();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)70);
            this.target.m_147240_(5.0, -deltaX / distance, -deltaZ / distance);
            this.mob.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f);
            this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
            this.mob.m_21573_().m_26569_();
        }

        public void m_8041_() {
            this.mob.setAnimationId(0);
            this.kickTimer = 0;
            kickCooldown = this.mob.isEnraged ? 50 : 100;
            this.target = null;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && kickCooldown <= 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class ShieldStampedeGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int chargeTime;
        private Vec3 chargeDirection;
        private static final int MAX_CHARGE_TIME = 40;

        public ShieldStampedeGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (stampedeCooldown > 0) return false;
            if (!(this.mob.m_20270_((Entity)this.target) >= 4.0f)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.m_217043_().m_188501_();
            float f2 = this.mob.isEnraged ? 0.25f : 0.15f;
            if (!(f >= f2)) return false;
            if (!(this.mob.m_217043_().m_188501_() <= 0.34f)) return false;
            if (!this.mob.m_20096_()) return false;
            return true;
        }

        public void m_8056_() {
            this.mob.setAnimationId(4);
            this.chargeTime = 0;
            this.chargeDirection = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_();
            this.mob.m_21573_().m_26573_();
            float targetYaw = (float)(Mth.m_14136_((double)this.chargeDirection.f_82481_, (double)this.chargeDirection.f_82479_) * 57.29577951308232) - 90.0f;
            this.mob.m_21563_().m_148051_((Entity)this.target);
            this.mob.m_146922_(targetYaw);
            this.mob.f_20883_ = targetYaw;
            this.mob.f_20885_ = targetYaw;
        }

        public void m_8037_() {
            ++this.chargeTime;
            if (this.target != null) {
                Vec3 newMovement = new Vec3(this.chargeDirection.f_82479_ * this.mob.getCurrentSpeed() * 1.5, this.mob.m_20184_().f_82480_, this.chargeDirection.f_82481_ * this.mob.getCurrentSpeed() * 1.5);
                this.mob.m_20256_(newMovement);
                if (this.chargeTime % 2 == 0) {
                    this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)69);
                }
                if (this.mob.m_20191_().m_82400_(1.0).m_82381_(this.target.m_20191_())) {
                    this.applyChargeDamage();
                    this.m_8041_();
                }
            }
        }

        private void applyChargeDamage() {
            Player player;
            float damage = (float)this.mob.getCurrentDamage();
            this.target.m_5997_(this.chargeDirection.f_82479_ * 4.0, this.chargeDirection.f_82480_ * 0.25, this.chargeDirection.f_82481_ * 4.0);
            this.mob.m_5496_((SoundEvent)MLSounds.WARBORN_AEGIS_STAMPEDE_HIT.get(), 1.0f, 1.0f);
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                ItemStack shieldItem = player.m_21211_();
                shieldItem.m_41622_(100, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                return;
            }
            this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
        }

        public void m_8041_() {
            this.mob.setAnimationId(0);
            stampedeCooldown = this.mob.isEnraged ? 200 : 400;
            this.chargeTime = 0;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.chargeTime < 40 && stampedeCooldown <= 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class MeteorSlamGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int attackTick;
        private boolean hasJumped;
        private static final int PRE_JUMP_DURATION = 20;
        private static final int JUMP_DURATION = 40;

        public MeteorSlamGoal(WarbornAegisEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (meteorCooldown > 0) return false;
            if (!(this.mob.m_20270_((Entity)this.target) <= 4.0f)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.m_217043_().m_188501_();
            float f2 = this.mob.isEnraged ? 0.35f : 0.26f;
            if (!(f >= f2)) return false;
            if (!(this.mob.m_217043_().m_188501_() <= 0.45f)) return false;
            if (!this.canJump()) return false;
            return true;
        }

        private boolean canJump() {
            BlockPos pos = this.mob.m_20183_();
            for (int i = 1; i <= 3; ++i) {
                if (this.mob.m_9236_().m_8055_(pos.m_6630_(i)).m_60795_()) continue;
                return false;
            }
            return true;
        }

        public void m_8056_() {
            this.mob.setAnimationId(2);
            this.attackTick = 0;
            this.hasJumped = false;
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            ++this.attackTick;
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                if (this.attackTick <= 20) {
                    this.handlePreparation();
                } else if (!this.hasJumped) {
                    this.hasJumped = true;
                    this.executeJump();
                } else if (!this.mob.m_20096_()) {
                    this.handleAirborne();
                } else if (this.attackTick >= 40) {
                    this.handleLanding();
                    this.m_8041_();
                }
            }
        }

        private void handlePreparation() {
            this.mob.m_5496_(SoundEvents.f_11784_, 10.0f, 1.0f);
            if (this.attackTick % 5 == 0) {
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)67);
            }
        }

        private void executeJump() {
            Vec3 targetPos = this.target.m_20182_();
            Vec3 direction = new Vec3(targetPos.f_82479_ - this.mob.m_20185_(), 0.0, targetPos.f_82481_ - this.mob.m_20189_()).m_82541_();
            double power = this.mob.isEnraged ? 1.5 : 1.2;
            this.mob.m_20334_(direction.f_82479_ * power, 1.0 + this.mob.m_217043_().m_188500_() * 0.5, direction.f_82481_ * power);
            this.mob.setAnimationId(3);
            this.mob.m_216990_((SoundEvent)MLSounds.WARBORN_AEGIS_JUMP.get());
        }

        private void handleAirborne() {
            if (this.mob.f_19797_ % 3 == 0) {
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)68);
            }
        }

        private void handleLanding() {
            Player player;
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                player.m_36384_(true);
            }
            this.mob.m_9236_().m_254849_((Entity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.isEnraged ? 6.0f : 4.0f, Level.ExplosionInteraction.NONE);
            this.mob.spawnIgnisNexus();
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)71);
            EffectScreenShake.ScreenShake(this.mob.m_9236_(), this.mob.m_20182_(), 15.0f, 1.0f, 0, 10);
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)-1);
            this.mob.m_21573_().m_26569_();
        }

        public void m_8041_() {
            this.mob.setAnimationId(0);
            this.hasJumped = false;
            this.attackTick = 0;
            meteorCooldown = this.mob.isEnraged ? 200 : 400;
            this.target = null;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && meteorCooldown <= 0 && this.canJump();
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

