/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.ImpaleAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.StunLockGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.SummonMinionsGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorInquisitorEntity
extends AbstractPossessedArmor {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE_INQUISITOR");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK_INQUISITOR");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK_INQUISITOR");
    private static final RawAnimation ATTACK_ALT = RawAnimation.begin().thenPlay("ATTACK_ALT_INQUISITOR");
    private static final RawAnimation IMPALE_ATTACK = RawAnimation.begin().thenPlay("IMPALE_ATTACK_INQUISITOR");
    private static final RawAnimation SLAM_ATTACK = RawAnimation.begin().thenPlay("SLAM_ATTACK_INQUISITOR");
    private static final RawAnimation SUMMON_ANIM = RawAnimation.begin().thenPlay("SUMMON_INQUISITOR");
    private static final RawAnimation STUN_ANIM = RawAnimation.begin().thenLoop("STUN_INQUISITOR");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_STUN_TICKS = SynchedEntityData.m_135353_(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SUMMON_TICKS = SynchedEntityData.m_135353_(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_STUNNED = SynchedEntityData.m_135353_(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int SLAM_COOLDOWN = 220;
    public int IMPALE_COOLDOWN = 200;
    public int SUMMON_COOLDOWN = 220;
    public int slamCooldown;
    public int impaleCooldown;
    public int summonCooldown;
    private final double STUN_CHANCE = 0.1;
    private final int BASE_STUN_DURATION = 80;
    public int STUN = 3;
    public int IMPALE = 4;
    public int SUMMON = 5;

    public PossessedArmorInquisitorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 75;
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor_inquisitor.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_inquisitor_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_inquisitor.png");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STUN_TICKS, (Object)80);
        this.f_19804_.m_135372_(DATA_SUMMON_TICKS, (Object)0);
        this.f_19804_.m_135372_(DATA_STUNNED, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("IsStunned")) {
            this.setStunned(pCompound.m_128471_("IsStunned"));
        }
        this.setStunTicks(pCompound.m_128451_("StunTicks"));
        this.setSummonTicks(pCompound.m_128451_("SummonTicks"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsStunned", this.isStunned());
        pCompound.m_128405_("StunTicks", this.getStunTicks());
        pCompound.m_128405_("SummonTicks", this.getSummonTicks());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_ARMOR).m_22268_(Attributes.f_22285_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_ARMOR_TOUGHNESS).m_22268_(Attributes.f_22281_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_DAMAGE).m_22268_(Attributes.f_22282_, DefaultMobAttributes.POSSESSED_ARMOR_ATTACK_INQUISITOR_KNOCKBACK).m_22268_(Attributes.f_22278_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.POSSESSED_ARMOR_FOLLOW_RANGE_INQUISITOR);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new StunLockGoal(this));
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new ImpaleAttackGoal(this));
        this.f_21345_.m_25352_(3, new SummonMinionsGoal<PossessedArmorEntity>(this, 2, 2, 250, PossessedArmorEntity.class));
        this.f_21345_.m_25352_(4, (Goal)new AnimatedMeleeAttackGoal(this, 40, 15, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new ChaseTargetGoal(this, false, 1.2));
    }

    @Override
    public void m_8119_() {
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        if (this.impaleCooldown > 0) {
            --this.impaleCooldown;
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
        super.m_8119_();
    }

    @Override
    protected void m_8024_() {
        if (this.getStunTicks() > 0) {
            this.setStunTicks(this.getStunTicks() - 1);
        }
        if (this.getSummonTicks() > 0) {
            this.setSummonTicks(this.getStunTicks() - 1);
        }
        super.m_8024_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        double chance = this.m_217043_().m_188500_();
        if (!this.m_9236_().f_46443_ && chance <= 0.1 && !this.isStunned() && this.getStunTicks() == 0 && this.getAnimationId() == this.SUMMON) {
            this.shouldApplyStun();
            pAmount *= 0.5f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7822_(byte id) {
        if (id == 69) {
            ParticleGeneratorHelper.generateShockwaveParticles(this.m_9236_(), (LivingEntity)this, 6.0);
        }
        if (id == 70) {
            ParticleGeneratorHelper.generateStunParticles(this.m_9236_(), (LivingEntity)this);
        }
        super.m_7822_(id);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void playSummonSound() {
        this.m_216990_((SoundEvent)MLSounds.INQUISITOR_SUMMONING.get());
    }

    public int getStunTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_STUN_TICKS);
    }

    public void setStunTicks(int pTicks) {
        this.f_19804_.m_135381_(DATA_STUN_TICKS, (Object)pTicks);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STUNNED);
    }

    public void setStunned(boolean pIsStunned) {
        this.f_19804_.m_135381_(DATA_STUNNED, (Object)pIsStunned);
    }

    public void setSummonTicks(int pTicks) {
        this.f_19804_.m_135381_(DATA_SUMMON_TICKS, (Object)pTicks);
    }

    public int getSummonTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_SUMMON_TICKS);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(DEATH);
        }
        if (this.isStunned() && this.getAnimationId() == this.STUN) {
            return state.setAndContinue(STUN_ANIM);
        }
        if (this.getAnimationId() == this.IMPALE) {
            return state.setAndContinue(IMPALE_ATTACK);
        }
        if (this.getAnimationId() == this.SUMMON) {
            return state.setAndContinue(SUMMON_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_() || this.isStunned() || this.getAnimationId() == this.SUMMON) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.m_6084_() && this.getAttackTicks() == 39) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 3, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ATTACK_KNOCKBACK.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.POSSESSED_ARMOR_INQUISITOR_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.POSSESSED_ARMOR_INQUISITOR_HEALTH.get()).doubleValue());
    }

    public void shouldApplyStun() {
        this.setStunned(true);
        this.setStunTicks(80);
    }
}

