/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorEntity
extends AbstractPossessedArmor {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation ATTACK_ALT = RawAnimation.begin().thenPlay("ATTACK_ALT");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");

    public PossessedArmorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 13;
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor.png");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.POSSESSED_ARMOR_HEALTH).m_22268_(Attributes.f_22279_, DefaultMobAttributes.POSSESSED_ARMOR_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.POSSESSED_ARMOR_FOLLOW_RANGE).m_22268_(Attributes.f_22284_, DefaultMobAttributes.POSSESSED_ARMOR_ARMOR).m_22268_(Attributes.f_22285_, DefaultMobAttributes.POSSESSED_ARMOR_ARMOR_TOUGHNESS).m_22268_(Attributes.f_22281_, DefaultMobAttributes.POSSESSED_ARMOR_DAMAGE).m_22268_(Attributes.f_22282_, DefaultMobAttributes.POSSESSED_ARMOR_ATTACK_KNOCKBACK).m_22268_(Attributes.f_22278_, DefaultMobAttributes.POSSESSED_ARMOR_KNOCKBACK_RESISTANCE);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.7f));
        this.f_21345_.m_25352_(3, (Goal)new ChaseTargetGoal(this, false, 1.2));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomSource = pLevel.m_213780_();
        this.m_213945_(randomSource, pDifficulty);
        this.m_213946_(randomSource, pDifficulty);
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(DEATH);
        }
        if (state.isMoving()) {
            return state.setAndContinue(WALK);
        }
        return state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.m_6084_() && this.getAttackTicks() == 19) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.getRandomAttackAnim());
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.POSSESSED_ARMOR_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)Config.POSSESSED_ARMOR_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.POSSESSED_ARMOR_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)Config.POSSESSED_ARMOR_ATTACK_KNOCKBACK.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.POSSESSED_ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.POSSESSED_ARMOR_HEALTH.get()).doubleValue());
    }

    private RawAnimation getRandomAttackAnim() {
        int id = this.m_217043_().m_188503_(2) + 1;
        return id == 1 ? ATTACK : ATTACK_ALT;
    }
}

