/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.ImpCloneEntity;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.MLMobType;
import com.ovinter.mythsandlegends.entity.ai.navigation.FlyingNavigation;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ImpEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("FLY");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation RANGED_ATTACK = RawAnimation.begin().thenPlay("RANGE_ATTACK");
    private static final EntityDataAccessor<Boolean> DATA_CLONE = SynchedEntityData.m_135353_(ImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private BlockPos boundOrigin;
    public static int shootCooldown = DefaultMobAttributes.IMP_SHOOT_ATTACK_COOLDOWN;
    public static int SHOOT = 2;

    public ImpEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new ImpMoveControl(this);
        this.f_21344_ = new FlyingNavigation((Mob)this, this.m_9236_());
        this.f_21364_ = 4;
        this.m_20242_(true);
    }

    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/imp.geo.json");
    }

    public ResourceLocation getTextureResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/imp.png");
    }

    public ResourceLocation getAnimationResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"animations/entity/imp.animation.json");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.IMP_HEALTH).m_22268_(Attributes.f_22280_, DefaultMobAttributes.IMP_FLYING_SPEED).m_22268_(Attributes.f_22281_, DefaultMobAttributes.IMP_DAMAGE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.IMP_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FireballAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ImpAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ImpRandomMoveGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLONE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsClone", this.isClone());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_CLONE, (Object)pCompound.m_128471_("IsClone"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (shootCooldown > 0) {
            --shootCooldown;
        }
        this.performCollisionAvoidance();
        if (this.m_9236_().m_5776_() && this.f_19797_ % 5 == 0) {
            ParticleGeneratorHelper.generateCircleParticles((LivingEntity)this, 5, ParticleTypes.f_175834_, false, false, 0.0, 0.0, 0.0, 0.2, 1.0);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomSource = pLevel.m_213780_();
        this.m_213945_(randomSource, pDifficulty);
        this.m_213946_(randomSource, pDifficulty);
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_276093_(DamageTypes.f_268493_) || pSource.m_269533_(DamageTypeTags.f_268549_);
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (!this.isClone()) {
            for (int i = 0; i < 2; ++i) {
                ImpCloneEntity clone = (ImpCloneEntity)((EntityType)MLEntities.IMP_CLONE.get()).m_20615_(this.m_9236_());
                if (clone == null) continue;
                clone.m_6034_(this.m_20185_() + 2.0, this.m_20186_(), this.m_20189_());
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, clone.m_20185_(), clone.m_20186_(), clone.m_20189_(), 0.0, 0.0, 0.0);
                }
                clone.setClone(true);
                this.m_9236_().m_7967_((Entity)clone);
            }
        }
        super.m_6667_(pDamageSource);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public MobType m_6336_() {
        return MLMobType.DEMON;
    }

    public boolean isClone() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CLONE);
    }

    public void setClone(boolean pClone) {
        this.f_19804_.m_135381_(DATA_CLONE, (Object)pClone);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected SoundEvent m_7515_() {
        this.m_5496_(SoundEvents.f_12270_, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_(SoundEvents.f_12501_, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        this.m_5496_(SoundEvents.f_12502_, 1.0f, 0.5f);
        return null;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    void castFireball(LivingEntity pTarget) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        double dirX = pTarget.m_20185_() - this.m_20185_();
        double dirY = pTarget.m_20227_(0.5) - this.m_20227_(0.5);
        double dirZ = pTarget.m_20189_() - this.m_20189_();
        Vec3 pos = new Vec3(dirX, dirY, dirZ);
        SmallFireball fireball = new SmallFireball(this.m_9236_(), (LivingEntity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        fireball.m_6034_(this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
        this.m_9236_().m_7967_((Entity)fireball);
        this.m_5496_((SoundEvent)MLSounds.IMP_SHOOT.get(), 2.0f, 1.0f);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        return state.isMoving() ? state.setAndContinue(FLY) : state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == SHOOT) {
            return state.setAndContinue(RANGED_ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate).triggerableAnim("attack", ATTACK).triggerableAnim("ranged", RANGED_ATTACK)});
    }

    @Override
    void setConfigAttributes() {
        if (this.isClone()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.IMP_CLONE_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.IMP_CLONE_DAMAGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22280_).m_22100_(((Double)Config.IMP_CLONE_FLYING_SPEED.get()).doubleValue());
            this.m_21153_((float)((Double)Config.IMP_CLONE_HEALTH.get()).doubleValue());
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.IMP_HEALTH.get()).doubleValue());
            this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.IMP_DAMAGE.get()).doubleValue());
            this.m_21051_(Attributes.f_22280_).m_22100_(((Double)Config.IMP_FLYING_SPEED.get()).doubleValue());
            this.m_21153_((float)((Double)Config.IMP_HEALTH.get()).doubleValue());
        }
    }

    private void performCollisionAvoidance() {
        this.avoidWalls();
        this.preventVerticalStuck();
        this.applyAntiStuckForce();
        this.smoothMovement();
    }

    private void avoidWalls() {
        Vec3 lookAhead = this.m_20182_().m_82549_(this.m_20154_().m_82490_(1.5));
        if (this.m_9236_().m_8055_(new BlockPos((int)lookAhead.f_82479_, (int)lookAhead.f_82480_, (int)lookAhead.f_82481_)).m_280296_()) {
            this.m_146922_(this.m_146908_() + (float)(this.f_19796_.m_188499_() ? 45 : -45));
        }
    }

    private void applyAntiStuckForce() {
        AABB bb = this.m_20191_();
        int checkRadius = 2;
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int y = -checkRadius; y <= checkRadius; ++y) {
                for (int z = -checkRadius; z <= checkRadius; ++z) {
                    BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                    if (!this.m_9236_().m_8055_(pos).m_280296_() || !bb.m_82314_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1))) continue;
                    Vec3 escapeDir = this.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)pos)).m_82541_();
                    this.m_20256_(this.m_20184_().m_82549_(escapeDir.m_82490_(0.1)));
                }
            }
        }
    }

    private void preventVerticalStuck() {
        BlockPos below = this.m_20183_().m_7495_();
        if (this.m_9236_().m_8055_(below).m_280296_() && this.m_20186_() - (double)below.m_123342_() < 1.5) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
        }
    }

    private void smoothMovement() {
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        if (speed > 0.1) {
            this.m_20256_(motion.m_82490_(0.97));
        }
        if (!this.m_6109_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.9, 0.9, 0.9));
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static class ImpMoveControl
    extends MoveControl {
        private final ImpEntity mob;

        public ImpMoveControl(ImpEntity pMob) {
            super((Mob)pMob);
            this.mob = pMob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < this.mob.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.mob.m_20256_(this.mob.m_20184_().m_82490_(0.5));
                } else {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (this.mob.m_5448_() == null) {
                        Vec3 vec31 = this.mob.m_20184_();
                        this.mob.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        this.mob.f_20883_ = this.mob.m_146908_();
                    } else {
                        double d2 = this.mob.m_5448_().m_20185_() - this.mob.m_20185_();
                        double d1 = this.mob.m_5448_().m_20189_() - this.mob.m_20189_();
                        this.mob.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        this.mob.f_20883_ = this.mob.m_146908_();
                    }
                }
            }
        }
    }

    public static class FireballAttackGoal
    extends Goal {
        private final ImpEntity mob;
        private LivingEntity target;
        private boolean hasShoot;
        private int attackTick;
        private int ATTACK_DURATION = 25;

        public FireballAttackGoal(ImpEntity pMob) {
            this.mob = pMob;
        }

        public void m_8056_() {
            this.mob.setAnimationId(SHOOT);
            this.mob.triggerAnim("attackController", "ranged");
            this.mob.m_21573_().m_26573_();
            this.attackTick = 0;
            this.hasShoot = false;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.m_6779_(this.target) && shootCooldown <= 0 && (double)this.mob.m_217043_().m_188501_() <= 0.14 && !this.mob.m_21224_();
        }

        public void m_8037_() {
            ++this.attackTick;
            if (this.target != null) {
                this.mob.m_21563_().m_24960_((Entity)this.target, 10.0f, 10.0f);
                if (!this.hasShoot) {
                    this.mob.castFireball(this.target);
                    this.hasShoot = true;
                    this.m_8041_();
                }
            }
            if (this.attackTick >= this.ATTACK_DURATION) {
                this.m_8041_();
            }
        }

        public void m_8041_() {
            this.target = null;
            this.mob.setAnimationId(0);
            this.mob.m_21573_().m_26569_();
            shootCooldown = DefaultMobAttributes.IMP_SHOOT_ATTACK_COOLDOWN;
            this.hasShoot = false;
            this.attackTick = 0;
            this.mob.stopTriggeredAnimation("attackController", "ranged");
        }

        public boolean m_183429_() {
            return true;
        }
    }

    public static class ImpAttackGoal
    extends Goal {
        private final ImpEntity imp;
        LivingEntity target;

        public ImpAttackGoal(ImpEntity imp) {
            this.imp = imp;
        }

        public boolean m_8036_() {
            this.target = this.imp.m_5448_();
            return this.target != null && this.target.m_6084_() && !this.imp.m_21566_().m_24995_() && this.imp.m_217043_().m_188503_(ImpAttackGoal.m_186073_((int)7)) == 0 && this.imp.m_20280_((Entity)this.target) > 3.0;
        }

        public boolean m_8045_() {
            return this.imp.m_21566_().m_24995_() && this.target != null && this.target.m_6084_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.target.m_146892_();
            this.imp.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            this.imp.m_5496_(SoundEvents.f_12500_, 1.0f, 0.6f);
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.imp.m_20191_().m_82381_(this.target.m_20191_())) {
                this.imp.m_7327_((Entity)this.target);
                this.imp.triggerAnim("attackController", "attack");
            } else {
                double distance = this.imp.m_20280_((Entity)this.target);
                if (distance < 9.0) {
                    Vec3 vec3 = this.target.m_146892_();
                    this.imp.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.1);
                }
            }
        }
    }

    public static class ImpRandomMoveGoal
    extends Goal {
        private final ImpEntity mob;

        public ImpRandomMoveGoal(ImpEntity pMob) {
            this.mob = pMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.mob.m_21566_().m_24995_() && this.mob.f_19796_.m_188503_(ImpRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public void m_8037_() {
            BlockPos blockPos = this.mob.getBoundOrigin();
            if (blockPos == null) {
                blockPos = this.mob.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos1 = blockPos.m_7918_(this.mob.f_19796_.m_188503_(15) - 7, this.mob.f_19796_.m_188503_(11) - 5, this.mob.f_19796_.m_188503_(15) - 7);
                if (!this.mob.m_9236_().m_46859_(blockPos1)) continue;
                this.mob.f_21342_.m_6849_((double)blockPos1.m_123341_() + 0.5, (double)blockPos1.m_123342_() + 0.5, (double)blockPos1.m_123343_() + 0.5, 0.25);
                if (this.mob.m_5448_() != null) break;
                this.mob.m_21563_().m_24950_((double)blockPos1.m_123341_() + 0.5, (double)blockPos1.m_123342_() + 0.5, (double)blockPos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

