/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.AwakeStateGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.scores.Team;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleEntity
extends MLEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation IDLE_AWAKE = RawAnimation.begin().thenLoop("IDLE_AWAKE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation SHOCKWAVE_ATTACK = RawAnimation.begin().thenPlay("SHOCKWAVE_ATTACK");
    private static final RawAnimation RANGED_ATTACK_ANIM = RawAnimation.begin().thenPlay("RANGED_ATTACK");
    private static final RawAnimation WINGS_IDLE_AWAKE = RawAnimation.begin().thenLoop("WINGS_IDLE_AWAKE");
    private static final RawAnimation WINGS_WALKING = RawAnimation.begin().thenLoop("WINGS_WALKING");
    private static final RawAnimation WINGS_ATTACKING = RawAnimation.begin().thenLoop("WINGS_ATTACKING");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Boolean> DATA_IS_AWAKE = SynchedEntityData.m_135353_(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static int SHOCKWAVE = 3;
    public static int shockwaveCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
    public int rangedCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;

    public GargoyleEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 18;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.GARGOYLE_HEALTH).m_22268_(Attributes.f_22281_, DefaultMobAttributes.GARGOYLE_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.GARGOYLE_MOVEMENT).m_22268_(Attributes.f_22282_, DefaultMobAttributes.GARGOYLE_ATTACK_KNOCKBACK).m_22268_(Attributes.f_22278_, DefaultMobAttributes.GARGOYLE_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.GARGOYLE_FOLLOW_RANGE);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_AWAKE, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("IsAwake")) {
            this.setAwake(pCompound.m_128471_("IsAwake"));
        }
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)pCompound.m_128451_("Variant"));
        if (pCompound.m_128403_("OwnerUUID")) {
            this.setOwner(pCompound.m_128342_("OwnerUUID"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsAwake", this.isAwake());
        pCompound.m_128405_("Variant", this.getVariant());
        this.getPersistentData().m_128405_("Variant", this.getVariant());
        if (this.getOwnerUUID() != null) {
            pCompound.m_128362_("OwnerUUID", this.getOwnerUUID());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AwakeStateGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ShockwaveAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.7f));
        this.f_21345_.m_25352_(5, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, target -> {
            UUID owner = this.getOwnerUUID();
            return owner == null || !target.m_20148_().equals(owner);
        }));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    public void m_8119_() {
        if (shockwaveCooldown > 0) {
            --shockwaveCooldown;
        }
        if (this.rangedCooldown > 0) {
            --this.rangedCooldown;
        }
        if (this.m_9236_().m_46462_()) {
            this.setAwake(true);
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 25 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (this.isNether()) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        float malus = this.getVariant() == 1 ? 0.0f : 1.0f;
        this.m_21441_(BlockPathTypes.LAVA, malus);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, malus);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, malus);
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.getOwnerUUID() == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_150930_((Item)MLItems.GARGOYLE_FRAGMENT.get())) {
            float health = this.m_21223_();
            this.m_5634_(10.0f);
            if (this.m_21223_() == health) {
                return InteractionResult.PASS;
            }
            this.m_5496_((SoundEvent)MLSounds.RUPTURE_BURST.get(), 1.0f, 1.0f);
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.getVariant() == 0 && itemStack.m_150930_(Items.f_42448_)) {
            pPlayer.m_5496_(SoundEvents.f_11780_, 1.0f, 1.0f);
            ItemStack itemStackResult = ItemUtils.m_41813_((ItemStack)itemStack, (Player)pPlayer, (ItemStack)BucketItem.m_40699_((ItemStack)itemStack, (Player)pPlayer));
            pPlayer.m_21008_(pHand, itemStackResult);
            this.setVariant(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        LivingEntity livingEntity;
        Entity entity;
        if ((pSource.m_276093_(DamageTypes.f_268566_) || pSource.m_276093_(DamageTypes.f_268464_)) && (entity = pSource.m_7639_()) instanceof LivingEntity && this.canBeHurtWithPickaxe(livingEntity = (LivingEntity)entity)) {
            pAmount *= 1.2f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6673_(DamageSource pSource) {
        LivingEntity livingEntity;
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && this.canBeHurtWithPickaxe(livingEntity = (LivingEntity)entity)) {
            return false;
        }
        return !this.isAwake() || pSource.m_276093_(DamageTypes.f_286979_) || pSource.m_269533_(DamageTypeTags.f_268524_) || pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_269533_(DamageTypeTags.f_268419_) || pSource.m_269533_(DamageTypeTags.f_268581_);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean success = super.m_7327_(pEntity);
        if (success && pEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)pEntity;
            double petrifiedChance = 0.15;
            if (this.m_9236_().f_46441_.m_188500_() < petrifiedChance) {
                this.performPetrifiedEffect(target);
            }
            this.playAttackSound();
        }
        return success;
    }

    public boolean m_5829_() {
        return !this.isAwake();
    }

    public boolean m_20147_() {
        return !this.isAwake();
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7822_(byte pId) {
        if (pId == 69 && !this.m_21224_()) {
            ParticleGeneratorHelper.generateShockwaveParticles(this.m_9236_(), (LivingEntity)this, 4.0);
        } else {
            super.m_7822_(pId);
        }
    }

    public void setAwake(boolean pAwake) {
        this.f_19804_.m_135381_(DATA_IS_AWAKE, (Object)pAwake);
    }

    public boolean isAwake() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_AWAKE);
    }

    public void setVariant(int pVariant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)pVariant);
        this.getPersistentData().m_128405_("Variant", pVariant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    public void setOwner(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(null);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.isAwake() ? (SoundEvent)MLSounds.GARGOYLE_HURT.get() : SoundEvents.f_271165_;
    }

    protected void playAttackSound() {
        this.m_5496_((SoundEvent)MLSounds.GARGOYLE_ATTACK.get(), 1.0f, 1.0f);
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isAwake() ? (SoundEvent)MLSounds.GARGOYLE_AMBIENT.get() : null;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.GARGOYLE_DEATH.get();
    }

    public boolean m_203441_(FluidState pFluidState) {
        return this.getVariant() == 1 && pFluidState.m_205070_(FluidTags.f_13132_);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_7307_(Entity pEntity) {
        if (pEntity == this) {
            return true;
        }
        UUID owner = this.getOwnerUUID();
        if (owner != null) {
            Wolf wolf;
            GargoyleEntity other;
            if (pEntity.m_20148_().equals(owner)) {
                return true;
            }
            if (pEntity instanceof GargoyleEntity && owner.equals((other = (GargoyleEntity)pEntity).getOwnerUUID())) {
                return true;
            }
            if (pEntity instanceof Wolf && owner.equals((wolf = (Wolf)pEntity).m_21805_())) {
                return true;
            }
        }
        return super.m_7307_(pEntity);
    }

    @Nullable
    public Team m_5647_() {
        LivingEntity owner;
        if (this.getOwnerUUID() != null && (owner = this.getOwner()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    private PlayState wingPredicate(AnimationState<?> state) {
        if (this.isAwake() && !this.m_21224_()) {
            if (this.getAnimationId() == 1) {
                return state.setAndContinue(WINGS_ATTACKING);
            }
            if (this.isAwake() && state.isMoving()) {
                return state.setAndContinue(WINGS_WALKING);
            }
            return state.setAndContinue(WINGS_IDLE_AWAKE);
        }
        return PlayState.STOP;
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_() && this.isAwake()) {
            return state.setAndContinue(DEATH);
        }
        if (this.isAwake() && this.getAnimationId() == SHOCKWAVE) {
            return state.setAndContinue(SHOCKWAVE_ATTACK);
        }
        if (this.isAwake() && this.getAnimationId() == 2) {
            return state.setAndContinue(RANGED_ATTACK_ANIM);
        }
        if (this.isAwake() && state.isMoving()) {
            return state.setAndContinue(WALK);
        }
        if (this.isAwake()) {
            return state.setAndContinue(IDLE_AWAKE);
        }
        return state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.isAwake() && this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.GARGOYLE_STEP.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "wingController", 5, this::wingPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.GARGOYLE_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.GARGOYLE_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22282_).m_22100_(((Double)Config.GARGOYLE_ATTACK_KNOCKBACK.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.GARGOYLE_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.GARGOYLE_HEALTH.get()).doubleValue());
    }

    private void performPetrifiedEffect(LivingEntity target) {
        target.m_7292_(new MobEffectInstance((MobEffect)MLEffects.PETRIFIED.get(), 40, 0));
        this.m_5496_((SoundEvent)MLSounds.PETRIFIED.get(), 1.0f, 1.0f);
    }

    private boolean canBeHurtWithPickaxe(LivingEntity livingEntity) {
        return livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof PickaxeItem;
    }

    private boolean isNether() {
        return this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207612_);
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : this.m_9236_().m_46003_(uuid);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.m_20183_());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.m_20280_((Entity)this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.f_19796_.m_216332_(-3, 3);
            int k = this.f_19796_.m_216332_(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.f_19796_.m_216332_(-1, 1);
            if (!this.maybeTeleportTo(pos.m_123341_() + j, pos.m_123342_() + l, pos.m_123343_() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        this.f_21344_.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathtype = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathtype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(pos.m_7495_());
        if (!this.canFlyToOwner() && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.m_20183_());
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(blockpos));
    }

    boolean canFlyToOwner() {
        return false;
    }

    public final boolean unableToMoveToOwner() {
        return this.m_20159_() || this.m_21523_() || this.getOwner() != null && this.getOwner().m_5833_();
    }

    public static class ShockwaveAttackGoal
    extends Goal {
        private final GargoyleEntity mob;
        LivingEntity target;
        private int attackTick;
        private final int ATTACK_DURATION = 25;

        public ShockwaveAttackGoal(GargoyleEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.mob.getAnimationId() == 0 && (double)this.mob.m_217043_().m_188501_() <= 0.14 && this.mob.isAwake() && this.mob.m_20270_((Entity)this.target) <= 4.0f && !this.mob.m_21224_() && this.mob.m_20096_() && this.mob.getVariant() == 0 && shockwaveCooldown <= 0;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && shockwaveCooldown <= 0;
        }

        public void m_8056_() {
            this.mob.setAnimationId(SHOCKWAVE);
            this.mob.m_21573_().m_26573_();
            this.attackTick = 0;
        }

        public void m_8037_() {
            ++this.attackTick;
            if (this.target != null && this.attackTick <= 25) {
                if (this.attackTick == 10) {
                    this.performShockwaveAttack();
                }
                if (this.attackTick >= 25) {
                    this.m_8041_();
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.target = null;
            this.mob.setAnimationId(0);
            this.mob.m_21573_().m_26569_();
            this.attackTick = 0;
            shockwaveCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
        }

        void performShockwaveAttack() {
            Level level = this.mob.m_9236_();
            List entities = level.m_6443_(Entity.class, this.mob.m_20191_().m_82400_(5.0), entity -> !(entity instanceof GargoyleEntity));
            for (Entity entity2 : entities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                double deltaX = entity2.m_20185_() - this.mob.m_20185_();
                double deltaZ = entity2.m_20189_() - this.mob.m_20189_();
                double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                entity2.m_6469_(level.m_269111_().m_269333_((LivingEntity)this.mob), 5.0f);
                if (distance == 0.0) continue;
                ((LivingEntity)entity2).m_147240_(3.0, -deltaX / distance, -deltaZ / distance);
            }
            level.m_7605_((Entity)this.mob, (byte)69);
            level.m_247517_(null, this.mob.m_20183_(), (SoundEvent)MLSounds.SHOCKWAVE.get(), SoundSource.HOSTILE);
        }
    }
}

