/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.BackStepAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.CustomHurtByTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.Spin360AttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AmarokEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation SPIN_ATTACK_ANIM = RawAnimation.begin().thenPlay("SPIN_ATTACK");
    private final RawAnimation BACKSTEP_JUMP_ANIM = RawAnimation.begin().thenPlay("BACKSTEP_JUMP");
    private final RawAnimation BACKSTEP_ATTACK_ANIM = RawAnimation.begin().thenLoop("BACKSTEP_ATTACK");
    private final RawAnimation HOWL_ANIM = RawAnimation.begin().thenPlay("HOWL");
    public int spinCooldown = DefaultMobAttributes.AMAROK_SPIN_COOLDOWN;
    public int rangedCooldown = DefaultMobAttributes.AMAROK_RANGED_COOLDOWN;
    public boolean showTailParticle = false;
    public int HOWL = 3;
    public int SPIN = 4;
    public int BACKSTEP_JUMP = 5;
    public int BACKSTEP_ATTACK = 6;

    public AmarokEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.f_21364_ = 37;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.AMAROK_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.AMAROK_ARMOR).m_22268_(Attributes.f_22281_, DefaultMobAttributes.AMAROK_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.AMAROK_MOVEMENT).m_22268_(Attributes.f_22278_, DefaultMobAttributes.AMAROK_KNOCKBACK_RESISTANCE).m_22268_(Attributes.f_22277_, DefaultMobAttributes.AMAROK_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new Spin360AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BackStepAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AnimatedMeleeAttackGoal(this, 20, 5, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new ChaseTargetGoal(this, false, 1.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 20.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new CustomHurtByTargetGoal(this, new Class[0]).m_26044_(new Class[]{Wolf.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, true));
    }

    public void m_8119_() {
        if (this.rangedCooldown > 0) {
            --this.rangedCooldown;
        }
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 60 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 80; ++i) {
                    server.m_8767_((ParticleOptions)((SimpleParticleType)MLParticles.SNOW_FLAKE_PARTICLE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 1.0, 1.0, 1.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_) || source.m_269533_(DamageTypeTags.f_268419_);
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return Mth.m_14167_((float)((pFallDistance - 5.0f) * pDamageMultiplier));
    }

    protected float m_6041_() {
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        if (state.m_60713_(Blocks.f_50126_) || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_) || state.m_60713_(Blocks.f_50449_)) {
            return 1.0f;
        }
        return super.m_6041_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5448_() != null) {
            return (SoundEvent)MLSounds.AMAROK_GROWL.get();
        }
        return this.m_217043_().m_188503_(100) < 1 ? (SoundEvent)MLSounds.AMAROK_HOWL.get() : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MLSounds.AMAROK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public void playHowlSound() {
        this.m_216990_((SoundEvent)MLSounds.AMAROK_HOWL.get());
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.HOWL_ANIM);
        }
        if (this.getAnimationId() == this.HOWL) {
            return state.setAndContinue(this.HOWL_ANIM);
        }
        if (this.getAnimationId() == this.SPIN) {
            return state.setAndContinue(this.SPIN_ATTACK_ANIM);
        }
        if (this.getAnimationId() == this.BACKSTEP_JUMP) {
            return state.setAndContinue(this.BACKSTEP_JUMP_ANIM);
        }
        if (this.getAnimationId() == 2) {
            return state.setAndContinue(this.BACKSTEP_ATTACK_ANIM);
        }
        if (state.isMoving() && this.isRunning()) {
            return state.setAndContinue(this.RUN_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setParticleKeyframeHandler(state -> {
            this.showTailParticle = state.getKeyframeData().getEffect().equals("tail");
        }).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("howl")) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.AMAROK_HOWL.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("attack")) {
                this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)MLSounds.AMAROK_ATTACK.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.AMAROK_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.AMAROK_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.AMAROK_DAMAGE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.AMAROK_HEALTH.get()).doubleValue());
    }

    public void performFrostHowl() {
        this.playHowlSound();
        List<Player> players = this.getNearbyPlayers(this.m_20191_().m_82400_(12.0));
        for (Player player : players) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        for (int i = 0; i < 50; ++i) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + 1.5, this.m_20189_() + this.f_19796_.m_188583_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public List<Player> getNearbyPlayers(AABB area) {
        return this.m_9236_().m_45976_(Player.class, area);
    }
}

