/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPossessedArmor
extends MLEntity {
    private static final EntityDataAccessor<Boolean> HAS_HALF_HEALTH = SynchedEntityData.m_135353_(AbstractPossessedArmor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_PLAYED_HALF_HEALTH = SynchedEntityData.m_135353_(AbstractPossessedArmor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractPossessedArmor(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 18;
    }

    public abstract ResourceLocation getModelResource();

    public abstract ResourceLocation getTextureResource();

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PossessedArmorEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_HALF_HEALTH, (Object)false);
        this.f_19804_.m_135372_(HAS_PLAYED_HALF_HEALTH, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Health")) {
            this.m_21153_(pCompound.m_128457_("Health"));
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Health", this.m_21223_());
    }

    public void m_8119_() {
        if (this.m_20096_() && this.m_9236_().m_5776_()) {
            ParticleGeneratorHelper.generateDustParticles((LivingEntity)this, 0.0f, 0.0f, 0.0f, !this.getHasHalfHealth() ? 1.0f : 1.5f, false, false);
        }
        if (!this.m_9236_().m_5776_()) {
            boolean currentlyHalfHealth;
            boolean bl = currentlyHalfHealth = this.m_21223_() <= this.m_21233_() / 2.0f;
            if (currentlyHalfHealth && !this.getHasHalfHealth()) {
                this.setHasHalfHealth(true);
            }
        }
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 25 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_21223_() <= this.m_21233_() / 2.0f && !this.getHasPlayedHalfHealth()) {
            this.m_5496_(SoundEvents.f_11794_, 10.0f, 0.3f);
            this.setHasPlayedHalfHealth(true);
            this.setHasHalfHealth(true);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity instanceof AbstractPossessedArmor) {
            return true;
        }
        return super.m_7307_(entity);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_269533_(DamageTypeTags.f_268745_) || pSource.m_269533_(DamageTypeTags.f_268581_);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.POSSESSED_ARMOR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void setHasHalfHealth(boolean hasHalfHealth) {
        this.f_19804_.m_135381_(HAS_HALF_HEALTH, (Object)hasHalfHealth);
    }

    public boolean getHasHalfHealth() {
        return (Boolean)this.f_19804_.m_135370_(HAS_HALF_HEALTH);
    }

    public void setHasPlayedHalfHealth(boolean hasHalfHealth) {
        this.f_19804_.m_135381_(HAS_PLAYED_HALF_HEALTH, (Object)hasHalfHealth);
    }

    public boolean getHasPlayedHalfHealth() {
        return (Boolean)this.f_19804_.m_135370_(HAS_PLAYED_HALF_HEALTH);
    }
}

