/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.datagen.MLAdvancementProvider;
import com.ovinter.mythsandlegends.datagen.MLBiomeTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLBlockStateProvider;
import com.ovinter.mythsandlegends.datagen.MLBlockTagProvider;
import com.ovinter.mythsandlegends.datagen.MLCuriosDataProvider;
import com.ovinter.mythsandlegends.datagen.MLEntityTypeTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLItemModelProvider;
import com.ovinter.mythsandlegends.datagen.MLItemTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLLootTableProvider;
import com.ovinter.mythsandlegends.datagen.MLParticleProvider;
import com.ovinter.mythsandlegends.datagen.MLRecipeProvider;
import com.ovinter.mythsandlegends.datagen.MLSoundDefinitionProvider;
import com.ovinter.mythsandlegends.datagen.biome.MLBiomeModifier;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mythsandlegends", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookUpProvider = event.getLookupProvider();
        RegistrySetBuilder builder = new RegistrySetBuilder().m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, MLBiomeModifier::bootstrap);
        MLBlockTagProvider blockTagsProvider = new MLBlockTagProvider(packOutput, lookUpProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new MLItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MLRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new MLAdvancementProvider(packOutput, lookUpProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MLSoundDefinitionProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)MLLootTableProvider.create(packOutput, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MLEntityTypeTagsProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookUpProvider, builder, Set.of("mythsandlegends")));
        generator.addProvider(event.includeServer(), (DataProvider)new MLBiomeTagsProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MLBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new MLCuriosDataProvider(packOutput, existingFileHelper, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MLItemTagsProvider(packOutput, lookUpProvider, blockTagsProvider.m_274426_()));
        generator.addProvider(event.includeClient(), (DataProvider)new MLParticleProvider(packOutput, existingFileHelper));
    }
}

