/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.util;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.entity.projectile.Flame_Jet_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Phantom_Halberd_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.message.MessageParticle;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

public class CSUtils {
    public static double getEyeHeight(LivingEntity entity) {
        return entity.m_20186_() + (double)entity.m_20192_() - 0.2;
    }

    public static void spawnHalberdWindmill(int numofBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay, LivingEntity caster, Level level, float damage, int spellLevel) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numofBranches);
        for (int branch = 0; branch < numofBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)i * curveFactor);
                double offsetX = currentRadius * Math.cos(currentAngle);
                double offsetZ = currentRadius * Math.sin(currentAngle);
                double spawnX = caster.m_20185_() + offsetX;
                double spawnY = caster.m_20186_() + 0.3;
                double spawnZ = caster.m_20189_() + offsetZ;
                int d1 = delay * (i + 1);
                double deltaX = level.f_46441_.m_188583_() * 0.007;
                double deltaY = level.f_46441_.m_188583_() * 0.007;
                double deltaZ = level.f_46441_.m_188583_() * 0.007;
                if (!level.m_5776_()) {
                    level.m_7106_((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), spawnX, spawnY, spawnZ, deltaX, deltaY, deltaZ);
                }
                CSUtils.spawnHalberds(spawnX, spawnZ, caster.m_20186_() - 5.0, caster.m_20186_() + 3.0, currentAngle, d1, damage, caster, level, spellLevel);
            }
        }
    }

    public static void spawnHalberds(double x, double z, double minY, double maxY, float rotation, int delay, float damage, LivingEntity caster, Level level, int spellLevel) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        int maxIterations = Mth.m_14045_((int)(spellLevel * 4), (int)1, (int)25);
        int iterationCount = 0;
        do {
            BlockState blockState1;
            VoxelShape shape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.m_8055_(pos1 = pos.m_7495_())).m_60783_((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.m_46859_(pos) && !(shape = (blockState1 = level.m_8055_(pos)).m_60812_((BlockGetter)level, pos)).m_83281_()) {
                d0 = shape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) && ++iterationCount < maxIterations);
        if (flag) {
            Phantom_Halberd_Entity phantomHalberd = new Phantom_Halberd_Entity(level, x, (double)pos.m_123342_() + d0, z, rotation, delay, caster, damage);
            level.m_7967_((Entity)phantomHalberd);
        }
    }

    public static boolean tryCurisumChestplateRebirth(LivingEntity livingEntity) {
        ItemStack chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST);
        if (!(chestplate.m_41720_() != ItemRegistries.CURSIUM_MAGE_CHESTPLATE.get() && chestplate.m_41720_() != ItemRegistries.CURSIUM_MAGE_CHESTPLATE_ELYTRA.get() || livingEntity.m_21023_((MobEffect)ModEffect.EFFECTGHOST_SICKNESS.get()) || livingEntity.m_21023_((MobEffect)ModEffect.EFFECTGHOST_FORM.get()))) {
            livingEntity.m_21153_(5.0f);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTGHOST_FORM.get(), 100, 0));
            double x = livingEntity.m_20185_();
            double y = livingEntity.m_20186_() + (double)0.3f;
            double z = livingEntity.m_20189_();
            float size = 3.0f;
            for (ServerPlayer serverPlayer : ((ServerLevel)livingEntity.m_9236_()).m_6907_()) {
                if (!(serverPlayer.m_20238_(Vec3.m_82512_((Vec3i)livingEntity.m_20183_())) < 1024.0)) continue;
                MessageParticle particle = new MessageParticle();
                for (float i = -size; i <= size; i += 1.0f) {
                    for (float j = -size; j <= size; j += 1.0f) {
                        for (float k = -size; k <= size; k += 1.0f) {
                            double d3 = (double)i + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                            double d4 = (double)j + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                            double d5 = (double)k + (livingEntity.m_217043_().m_188500_() - livingEntity.m_217043_().m_188500_()) * 0.5;
                            double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + livingEntity.m_217043_().m_188583_() * 0.05;
                            particle.queueParticle((ParticleOptions)ModParticle.CURSED_FLAME.get(), false, x, y, z, d3 / d6, d4 / d6, d5 / d6);
                            if (i == -size || i == size || j == -size || j == size) continue;
                            k += size * 2.0f - 1.0f;
                        }
                    }
                }
                Cataclysm.NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)particle);
            }
            return true;
        }
        return false;
    }

    public static void spawnFlameJets(Level level, double x, double z, double minY, double maxY, float rotation, int delay, LivingEntity caster, float damage) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape shape;
            BlockPos pos1;
            BlockState blockState;
            if (!(blockState = level.m_8055_(pos1 = pos.m_7495_())).m_60783_((BlockGetter)level, pos1, Direction.UP)) continue;
            if (!level.m_46859_(pos) && !(shape = (blockState1 = level.m_8055_(pos)).m_60812_((BlockGetter)level, pos)).m_83281_()) {
                d0 = shape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            Flame_Jet_Entity flameJet = new Flame_Jet_Entity(level, x, (double)pos.m_123342_() + d0, z, rotation, delay, damage, caster);
            level.m_7967_((Entity)flameJet);
        }
    }

    public static void spawnCircularFlameJets(float vec3, float math, int vertex, int rune, double time, Level level, LivingEntity caster, float damage) {
        float cos = Mth.m_14089_((float)((float)((double)caster.f_20883_ + Math.PI / 180)));
        float sin = Mth.m_14031_((float)((float)((double)caster.f_20883_ + Math.PI / 180)));
        double theta = (double)caster.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta);
        double vecZ = Math.sin(theta);
        for (int i = 0; i < vertex; ++i) {
            float angle = (float)((double)i * Math.PI / ((double)vertex / 2.0));
            for (int k = 0; k < rune; ++k) {
                double d2 = 1.1 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                CSUtils.spawnFlameJets(level, caster.m_20185_() + (double)vec3 * vecX + (double)(cos * math) + (double)Mth.m_14089_((float)angle) * 1.25 * d2, caster.m_20189_() + (double)vec3 * vecZ + (double)(sin * math) + (double)Mth.m_14031_((float)angle) * 1.25 * d2, caster.m_20186_() - 2.0, caster.m_20186_() + 2.0, angle, d3, caster, damage);
            }
        }
    }

    public static void spawnFlameJetWindmill(int numofBranches, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay, LivingEntity caster, Level level, float damage) {
        float angleIncrement = (float)(Math.PI * 2 / (double)numofBranches);
        for (int branch = 0; branch < numofBranches; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)i * curveFactor);
                double offsetX = currentRadius * Math.cos(currentAngle);
                double offsetZ = currentRadius * Math.sin(currentAngle);
                double spawnX = caster.m_20185_() + offsetX;
                double spawnY = caster.m_20186_() + 0.3;
                double spawnZ = caster.m_20189_() + offsetZ;
                int d1 = delay * (i + 1);
                double deltaX = level.f_46441_.m_188583_() * 0.007;
                double deltaY = level.f_46441_.m_188583_() * 0.007;
                double deltaZ = level.f_46441_.m_188583_() * 0.007;
                if (!level.m_5776_()) {
                    level.m_7106_((ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), spawnX, spawnY, spawnZ, deltaX, deltaY, deltaZ);
                }
                CSUtils.spawnFlameJets(level, spawnX, spawnZ, caster.m_20186_() - 5.0, caster.m_20186_() + 3.0, currentAngle, d1, caster, damage);
            }
        }
    }

    public static boolean isValidUnlockItemInInventory(Item item, Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (itemStack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCurio(Player player, Item item) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent();
    }

    public static float getDamageForAttributes(AbstractSpell spell, LivingEntity entity, int spellLevel, Attribute attr1, float modifier) {
        double attrValue1 = entity.m_21133_(attr1);
        float damage = (float)((double)modifier * ((double)spell.getSpellPower(spellLevel, (Entity)entity) + attrValue1));
        return damage;
    }
}

