/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class SoftwareUpdateSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"software_update");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(3).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getEffectDuration(spellLevel, caster), (int)1)}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageMovementSpeed(spellLevel), (int)0), Component.m_237115_((String)"attribute.name.generic.movement_speed")}), Component.m_237110_((String)"attribute.modifier.plus.1", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageCooldown(spellLevel), (int)0), Component.m_237115_((String)"attribute.irons_spellbooks.cooldown_reduction")}));
    }

    public SoftwareUpdateSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!(entity.m_21023_((MobEffect)MobEffectRegistry.CHARGED.get()) && entity.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get()) && entity.m_21023_((MobEffect)CSPotionEffectRegistry.HARDWARE_UPDATE_EFFECT.get()))) {
            entity.m_21195_((MobEffect)MobEffectRegistry.CHARGED.get());
            entity.m_21195_((MobEffect)MobEffectRegistry.HASTENED.get());
            entity.m_21195_((MobEffect)CSPotionEffectRegistry.HARDWARE_UPDATE_EFFECT.get());
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.SOFTWARE_UPDATE_EFFECT.get(), this.getEffectDuration(spellLevel, entity), spellLevel - 1, true, true, true));
        } else {
            entity.m_21195_((MobEffect)MobEffectRegistry.CHARGED.get());
            entity.m_21195_((MobEffect)MobEffectRegistry.HASTENED.get());
            entity.m_21195_((MobEffect)CSPotionEffectRegistry.HARDWARE_UPDATE_EFFECT.get());
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.SOFTWARE_UPDATE_EFFECT.get(), this.getEffectDuration(spellLevel, entity), spellLevel - 1, true, true, true));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getEffectDuration(int spellLevel, LivingEntity caster) {
        int amount = (int)(this.getSpellPower(spellLevel, (Entity)caster) * 20.0f);
        return amount;
    }

    private float getPercentageMovementSpeed(int spellLevel) {
        return (float)spellLevel * 0.05f * 100.0f;
    }

    private float getPercentageCooldown(int spellLevel) {
        return (float)spellLevel * 0.1f * 100.0f;
    }
}

