/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.technomancy;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class OverchargedSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"overcharged");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(CSSchoolRegistry.TECHNOMANCY_RESOURCE).setMaxLevel(3).setCooldownSeconds(10.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.stringTruncation((double)((double)this.getEffectDuration() / 20.0), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.effect_percentage", (Object[])new Object[]{Utils.stringTruncation((double)this.getPercentageEffectAmplifier(), (int)2)}));
    }

    public OverchargedSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 150;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), this.getEffectDuration(), castSource, null), playerMagicData);
        }
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_POWER_CHESTPLATE.get() && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_POWER_HELMET.get()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.MANA_OVERCHARGED_EFFECT.get(), this.getEffectDuration(), 0, true, true, true));
        } else if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_RESIST_CHESTPLATE.get() && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_RESIST_HELMET.get()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.SPELL_RES_OVERCHARGED_EFFECT.get(), this.getEffectDuration(), 0, true, true, true));
        } else if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_SPEED_CHESTPLATE.get() && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_SPEED_HELMET.get()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.COOLDOWN_OVERCHARGED_EFFECT.get(), this.getEffectDuration(), 0, true, true, true));
        } else {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.BASE_OVERCHARGED_EFFECT.get(), this.getEffectDuration(), 0, true, true, true));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        if (serverPlayer.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_POWER_CHESTPLATE.get() || serverPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_POWER_HELMET.get()) {
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.MANA_OVERCHARGED_EFFECT.get());
        } else if (serverPlayer.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_RESIST_CHESTPLATE.get() || serverPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_RESIST_HELMET.get()) {
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.SPELL_RES_OVERCHARGED_EFFECT.get());
        } else if (serverPlayer.m_6844_(EquipmentSlot.CHEST).m_41720_() == ItemRegistries.EXCELSIUS_SPEED_CHESTPLATE.get() || serverPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemRegistries.EXCELSIUS_SPEED_HELMET.get()) {
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.COOLDOWN_OVERCHARGED_EFFECT.get());
        } else {
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.MANA_OVERCHARGED_EFFECT.get());
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.SPELL_RES_OVERCHARGED_EFFECT.get());
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.COOLDOWN_OVERCHARGED_EFFECT.get());
            serverPlayer.m_21195_((MobEffect)CSPotionEffectRegistry.BASE_OVERCHARGED_EFFECT.get());
        }
    }

    private float getPercentageEffectAmplifier() {
        return 50.0f;
    }

    public int getEffectDuration() {
        return 1200;
    }
}

