/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.nature;

import com.github.L_Ender.cataclysm.entity.projectile.Sandstorm_Projectile;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class DesertWindsSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"desert_winds");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(10).setCooldownSeconds(8.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}));
    }

    public DesertWindsSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 20;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        this.summonSandstormProjectile(spellLevel, entity);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void summonSandstormProjectile(int spellLevel, LivingEntity caster) {
        Level level = caster.m_9236_();
        double casterX = caster.m_20185_();
        double casterEyeHeight = CSUtils.getEyeHeight(caster);
        double casterZ = caster.m_20189_();
        float casterYRot = caster.m_146908_();
        float casterXRot = caster.m_146909_();
        float d1 = -Mth.m_14031_((float)(casterYRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(casterXRot * ((float)Math.PI / 180)));
        float d2 = -Mth.m_14031_((float)(casterXRot * ((float)Math.PI / 180)));
        float d3 = Mth.m_14089_((float)(casterYRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(casterXRot * ((float)Math.PI / 180)));
        double theta = (double)casterYRot * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vexZ = Math.sin(theta);
        double x = casterX + vecX;
        double z = casterZ + vexZ;
        Sandstorm_Projectile sandstormProjectile = new Sandstorm_Projectile(caster, (double)d1, (double)d2, (double)d3, level, this.getDamage(spellLevel, caster));
        sandstormProjectile.setState(1);
        sandstormProjectile.m_6034_(x, casterEyeHeight, z);
        level.m_7967_((Entity)sandstormProjectile);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }
}

