/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ice;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Axe_Blade_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.spells.ice.AbstractMaledictusSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class PhantasmalBladeSpell
extends AbstractMaledictusSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"phantasmal_blade");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(25.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.phantom_blades", (Object[])new Object[]{spellLevel + 3}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.maledictus_armory_bonus", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)1)}));
    }

    public PhantasmalBladeSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 16;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.OVERHEAD_MELEE_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get());
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 3;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        Item soulRenderer = (Item)ModItems.SOUL_RENDER.get();
        Item annihilator = (Item)ModItems.THE_ANNIHILATOR.get();
        if (entity.m_21205_().m_150930_(soulRenderer) || entity.m_21205_().m_150930_(annihilator)) {
            this.summonAxeBlades(level, entity, spellLevel, this.getBonusDamage(spellLevel, entity));
        } else {
            this.summonAxeBlades(level, entity, spellLevel, this.getDamage(spellLevel, entity));
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void summonAxeBlades(Level level, LivingEntity caster, int spellLevel, float damage) {
        double theta = (double)caster.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += Math.PI * 2);
        double vecZ = Math.sin(theta);
        float angleStep = 30.0f;
        for (int i = 0; i < spellLevel + 3; ++i) {
            float angle = caster.f_20883_ + ((float)i - (float)spellLevel / 2.0f) * angleStep;
            float rad = (float)Math.toRadians(angle);
            double dX = -Math.sin(rad);
            double dZ = Math.cos(rad);
            Axe_Blade_Entity axeBladeEntity = new Axe_Blade_Entity(caster, dX, 0.0, dZ, level, damage, angle);
            double spawnX = caster.m_20185_();
            double spawnY = caster.m_20227_(0.15);
            double spawnZ = caster.m_20189_();
            axeBladeEntity.m_6034_(spawnX, spawnY, spawnZ);
            level.m_7967_((Entity)axeBladeEntity);
        }
        EarthquakeAoe aoe = new EarthquakeAoe(level);
        aoe.m_20219_(caster.m_20182_());
        aoe.m_5602_((Entity)caster);
        aoe.setCircular();
        aoe.setRadius(6.0f);
        aoe.setDuration(20);
        aoe.setDamage(0.0f);
        aoe.setSlownessAmplifier(0);
        level.m_7967_((Entity)aoe);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)6.0f, (float)0.05f, (int)20, (int)20);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setFreezeTicks(100);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 1.2f;
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getDamage(spellLevel, caster);
        int bonusAmount = (int)(3.5 + (double)spellLevel);
        return baseDamage + (float)bonusAmount;
    }
}

