/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ice;

import com.github.L_Ender.cataclysm.init.ModItems;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.ice.AbstractMaledictusSpell;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class CursedRushSpell
extends AbstractMaledictusSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"cursed_rush");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(3).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.m_237115_((String)"ui.cataclysm_spellbooks.halberd_rush"), Component.m_237110_((String)"ui.cataclysm_spellbooks.soul_render_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)1)}));
    }

    public CursedRushSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 2;
        this.castTime = 10;
        this.baseManaCost = 100;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public ICastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    public void onClientCast(Level level, int spellLevel, LivingEntity entity, ICastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData data = (ImpulseCastData)castData;
            entity.f_19812_ = data.hasImpulse;
            entity.m_20256_(entity.m_20184_().m_82520_((double)data.x, (double)data.y, (double)data.z));
        }
        super.onClientCast(level, spellLevel, entity, castData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.f_19812_ = true;
        float multiplier = (this.getSpellPower(spellLevel, (Entity)entity) + (float)(spellLevel + 10)) / 10.0f;
        Vec3 forwards = entity.m_20154_();
        if (playerMagicData.getAdditionalCastData() instanceof CursedRushDirectionOverrideCastData) {
            forwards = Utils.random.m_188499_() ? forwards.m_82524_(90.0f) : forwards.m_82524_(-90.0f);
        }
        Vec3 vec3 = forwards.m_82542_(3.0, 1.0, 3.0).m_82541_().m_82520_(0.0, 0.25, 0.0).m_82490_((double)multiplier);
        if (entity.m_20096_()) {
            entity.m_146884_(entity.m_20182_().m_82520_(0.0, 1.5, 0.0));
            vec3.m_82520_(0.0, 0.25, 0.0);
        }
        playerMagicData.setAdditionalCastData((ICastData)new ImpulseCastData((float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_, true));
        entity.m_20256_(new Vec3(Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82479_, (double)vec3.f_82479_), Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82480_, (double)vec3.f_82480_), Mth.m_14139_((double)0.75, (double)entity.m_20184_().f_82481_, (double)vec3.f_82481_)));
        Item soulRenderer = (Item)ModItems.SOUL_RENDER.get();
        if (entity.m_21205_().m_150930_(soulRenderer)) {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.CURSED_FRENZY.get(), 20, (int)this.getBonusDamage(spellLevel, entity), false, false, false));
        } else {
            entity.m_7292_(new MobEffectInstance((MobEffect)CSPotionEffectRegistry.CURSED_FRENZY.get(), 20, (int)this.getDamage(spellLevel, entity), false, false, false));
        }
        CSUtils.spawnHalberdWindmill(5, 5, 1.0, 1.0, 0.2f, 1, entity, level, 5.0f, spellLevel);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) + 5.0f;
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getDamage(spellLevel, caster);
        int bonusAmount = (int)(3.5 + (double)spellLevel);
        return baseDamage + (float)bonusAmount;
    }

    private static class CursedRushDirectionOverrideCastData
    implements ICastData {
        private CursedRushDirectionOverrideCastData() {
        }

        public void reset() {
        }
    }
}

