/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedAptrgangr;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedEliteDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.SummonedRoyalDraugur;
import net.acetheeldritchking.cataclysm_spellbooks.spells.abyssal.AbstractAbyssalSummonSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ConjureThrallsSpell
extends AbstractAbyssalSummonSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"conjure_thralls");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(10).setCooldownSeconds(120.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.thrall_count", (Object[])new Object[]{spellLevel}));
    }

    public ConjureThrallsSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 80;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    protected int onSummoningCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData, SummonedEntitiesCastData castData) {
        int summonTimer = 12000;
        for (int i = 0; i < spellLevel; ++i) {
            Vec3 vec = caster.m_146892_();
            double randomNearbyX = vec.f_82479_ + caster.m_217043_().m_188583_() * 3.0;
            double randomNearbyZ = vec.f_82481_ + caster.m_217043_().m_188583_() * 3.0;
            this.spawnHelper(randomNearbyX, vec.f_82480_, randomNearbyZ, caster, level, summonTimer, castData, () -> {
                boolean isRoyal = Utils.random.m_188500_() < 0.4;
                boolean isElite = Utils.random.m_188500_() < 0.5;
                boolean isAptrgangr = Utils.random.m_188500_() < 0.2;
                boolean isBase = Utils.random.m_188500_() < 0.6;
                boolean isFullArmy = Utils.random.m_188500_() < 0.75;
                SummonedDraugur draugur = new SummonedDraugur(level, caster);
                SummonedRoyalDraugur royalDraugur = new SummonedRoyalDraugur(level, caster);
                SummonedEliteDraugur eliteDraugur = new SummonedEliteDraugur(level, caster);
                SummonedAptrgangr aptrgangr = new SummonedAptrgangr(level, caster);
                IMagicSummon isBaseDraugur = isRoyal ? draugur : royalDraugur;
                IMagicSummon isEliteDraugur = isElite ? eliteDraugur : royalDraugur;
                SummonedAptrgangr isAptrgangrDraugur = isAptrgangr ? aptrgangr : isEliteDraugur;
                IMagicSummon baseArmy = isBase ? isBaseDraugur : isEliteDraugur;
                return isFullArmy ? baseArmy : isAptrgangrDraugur;
            });
        }
        return summonTimer;
    }
}

