/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.holy;

import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.mobs.PhantomAncientRemnant;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.acetheeldritchking.cataclysm_spellbooks.spells.AbstractSummonSpell;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class ThothsWitnessSpell
extends AbstractSummonSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"thoths_witness");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(1).setCooldownSeconds(600.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.remnant_count", (Object[])new Object[]{spellLevel}));
    }

    public ThothsWitnessSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 100;
        this.baseManaCost = 650;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public CastResult canBeCastedBy(int spellLevel, CastSource castSource, MagicData playerMagicData, Player player) {
        if (castSource == CastSource.SCROLL) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"ui.cataclysm_spellbooks.thoths_witness_scroll_failure", (Object[])new Object[]{this.getDisplayName(player)}).m_130940_(ChatFormatting.RED));
        }
        if (!(player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistries.PHARAOH_MAGE_HELMET.get()) || player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistries.PHARAOH_MAGE_CHESTPLATE.get()) || player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistries.PHARAOH_MAGE_LEGGINGS.get()) || player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistries.PHARAOH_MAGE_BOOTS.get()))) {
            return new CastResult(CastResult.Type.FAILURE, (Component)Component.m_237110_((String)"ui.cataclysm_spellbooks.thoths_witness_armor_failure", (Object[])new Object[]{this.getDisplayName(player)}).m_130940_(ChatFormatting.RED));
        }
        return super.canBeCastedBy(spellLevel, castSource, playerMagicData, player);
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11699_);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.REMNANT_ROAR.get());
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        EarthquakeAoe aoe = new EarthquakeAoe(level);
        aoe.m_20219_(entity.m_20182_());
        aoe.m_5602_((Entity)entity);
        aoe.setCircular();
        aoe.setRadius(10.0f);
        aoe.setDuration(this.getCastTime(spellLevel));
        aoe.setDamage(0.0f);
        aoe.setSlownessAmplifier(0);
        level.m_7967_((Entity)aoe);
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        float random = 0.04f;
        float r = 0.89f + entity.m_217043_().m_188501_() * random;
        float g = 0.85f + entity.m_217043_().m_188501_() * random;
        float b = 0.69f + entity.m_217043_().m_188501_() * random * 1.5f;
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.75f + entity.m_217043_().m_188501_() * 0.6f, 3.75f + entity.m_217043_().m_188501_() * 0.6f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.5f + entity.m_217043_().m_188501_() * 0.45f, 3.0f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 2.25f + entity.m_217043_().m_188501_() * 0.45f, 2.25f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new StormParticle.OrbData(r, g, b, 1.25f + entity.m_217043_().m_188501_() * 0.45f, 1.25f + entity.m_217043_().m_188501_() * 0.45f, entity.m_19879_()), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
        if (entity.f_19797_ % 10 == 0) {
            int count = 16;
            float particleRadius = 1.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius;
                double z = Math.sin(theta) * (double)particleRadius;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.DESERT_GLYPH.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count2 = 16;
            float particleRadius2 = 2.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count2) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius2;
                double z = Math.sin(theta) * (double)particleRadius2;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.DESERT_GLYPH.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
            int count3 = 16;
            float particleRadius3 = 3.25f;
            for (int i = 0; i < count; ++i) {
                double theta = Math.toRadians(360.0 / (double)count3) * (double)i;
                double x = Math.cos(theta) * (double)particleRadius3;
                double z = Math.sin(theta) * (double)particleRadius3;
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)((ParticleOptions)ModParticle.DESERT_GLYPH.get()), (double)(entity.m_20182_().f_82479_ + x), (double)entity.m_20182_().f_82480_, (double)(entity.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
            }
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onClientPreCast(Level level, int spellLevel, LivingEntity entity, InteractionHand hand, @Nullable MagicData playerMagicData) {
        super.onClientPreCast(level, spellLevel, entity, hand, playerMagicData);
    }

    @Override
    protected int onSummoningCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData, SummonedEntitiesCastData castData) {
        int summonTimer = 1200;
        Vec3 vec = caster.m_146892_();
        double randomNearbyX = vec.f_82479_ + caster.m_217043_().m_188583_() * 1.5;
        double randomNearbyZ = vec.f_82481_ + caster.m_217043_().m_188583_() * 1.5;
        PhantomAncientRemnant ancientRemnant = this.spawnHelper(randomNearbyX, caster.m_20186_(), randomNearbyZ, caster, level, summonTimer, castData, () -> new PhantomAncientRemnant(level, caster));
        ancientRemnant.setSleep(false);
        EarthquakeAoe aoe = new EarthquakeAoe(level);
        aoe.m_20219_(ancientRemnant.m_20182_());
        aoe.m_5602_((Entity)ancientRemnant);
        aoe.setCircular();
        aoe.setRadius(6.0f);
        aoe.setDuration(20);
        aoe.setDamage(0.0f);
        aoe.setSlownessAmplifier(0);
        level.m_7967_((Entity)aoe);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), 6.0f), (double)caster.m_20185_(), (double)(caster.m_20186_() + (double)0.8f), (double)caster.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)6.0f, (float)0.15f, (int)20, (int)20);
        return summonTimer;
    }
}

