/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.hellish_blade.HellishBladeProjectile;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class HellishBladeSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"hellish_blade");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(90.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.incinerator_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)2)}));
    }

    public HellishBladeSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 150;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIREBALL_START.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.IGNIS_ARMOR_BREAK.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)32, (float)0.15f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetEntityCastData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetEntityCastData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float bonusDamage;
            double targetEye = targetEntity.m_20192_();
            float MAX_HEALTH = entity.m_21233_();
            float baseHealth = entity.m_21223_();
            double percent = baseHealth / MAX_HEALTH * 100.0f;
            Item incinerator = (Item)ModItems.THE_INCINERATOR.get();
            Vec3 center = targetEntity.m_20182_().m_82520_(0.0, targetEye / 2.0, 0.0);
            Vec3 spawn = center.m_82520_(0.0, 10.0, 0.0);
            Vec3 motion = center.m_82546_(spawn).m_82541_();
            HellishBladeProjectile hellishBlade = new HellishBladeProjectile(level, entity);
            hellishBlade.m_20219_(spawn);
            hellishBlade.shoot(motion);
            float damage = hellishBlade.getIsSoul() ? this.getDamage(spellLevel, entity) * 1.5f : this.getDamage(spellLevel, entity);
            float f = bonusDamage = hellishBlade.getIsSoul() ? this.getBonusDamage(spellLevel, entity) * 1.5f : this.getBonusDamage(spellLevel, entity);
            if (percent <= 50.0) {
                hellishBlade.setIsSoul(true);
            } else {
                hellishBlade.setIsSoul(false);
            }
            if (entity.m_21205_().m_150930_(incinerator)) {
                hellishBlade.setDamage(bonusDamage);
            } else {
                hellishBlade.setDamage(damage);
            }
            level.m_7967_((Entity)hellishBlade);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getDamage(spellLevel, caster);
        int bonusAmount = (int)(1.5 + (double)spellLevel);
        return baseDamage + (float)bonusAmount;
    }
}

