/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.projectile.Blazing_Bone_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class BonePierceSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"piercing_bone");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(8).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.cataclysm_spellbooks.blazing_bone_speed", (Object[])new Object[]{Utils.stringTruncation((double)this.getBoneSpeed(0.05f, this.getSpellPower(spellLevel, (Entity)caster)), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public BonePierceSpell() {
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        this.shootBone(entity, spellLevel, level);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult == RecastResult.USED_ALL_RECASTS) {
            Level level = serverPlayer.m_9236_();
            this.spreadBoneShoot((LivingEntity)serverPlayer, level);
        }
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
    }

    private void shootBone(LivingEntity caster, int spellLevel, Level level) {
        caster.m_5496_(SoundEvents.f_12520_, 1.0f, 0.75f);
        double casterX = caster.m_20185_();
        double casterY = CSUtils.getEyeHeight(caster);
        double casterZ = caster.m_20189_();
        Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, this.getDamage(spellLevel, caster), caster);
        blazingBone.m_7678_(casterX, casterY, casterZ, 0.0f, caster.m_146909_());
        float speed = 0.05f;
        float speedSpellPower = this.getBoneSpeed(speed, this.getSpellPower(spellLevel, (Entity)caster));
        blazingBone.m_20242_(true);
        blazingBone.m_37251_((Entity)caster, caster.m_146909_(), caster.m_6080_(), 0.0f, speedSpellPower, 1.0f);
        level.m_7967_((Entity)blazingBone);
    }

    private void spreadBoneShoot(LivingEntity caster, Level level) {
        caster.m_5496_(SoundEvents.f_12520_, 1.0f, 0.75f);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)((double)i * Math.PI / 4.0);
            double casterX = caster.m_20185_() + (double)Mth.m_14089_((float)throwAngle);
            double casterY = caster.m_20186_() + (double)caster.m_20206_() * 0.62;
            double casterZ = caster.m_20189_() + (double)Mth.m_14031_((float)throwAngle);
            double angleX = Mth.m_14089_((float)throwAngle);
            double angleY = 0.2;
            double angleZ = Mth.m_14031_((float)throwAngle);
            Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, 3.0f, caster);
            blazingBone.m_7678_(casterX, casterY, casterZ, (float)i * 45.0f, caster.m_146909_());
            float speed = 0.5f;
            blazingBone.m_20242_(true);
            blazingBone.m_6686_(angleX, angleY, angleZ, speed, 1.0f);
            level.m_7967_((Entity)blazingBone);
        }
    }

    private float getBoneSpeed(float speed, float spellPower) {
        return speed * spellPower;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }
}

