/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.blood;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.quick_strike.QuickStrikeAoE;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSoundRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.spells.CSSpellAnimations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class QuickStrikeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"quick_strike");
    private Boolean mirrored;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(CSSchoolRegistry.BLOOD_RESOURCE).setMaxLevel(5).setCooldownSeconds(25.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{this.getDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.stringTruncation((double)this.getEffectDuration(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.cataclysm_spellbooks.recast_bonus_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)1)}));
    }

    public QuickStrikeSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 3;
        this.castTime = 6;
        this.baseManaCost = 50;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        if (this.mirrored.booleanValue()) {
            return CSSpellAnimations.ANIMATION_LEFT_HORIZONTAL_SLASH;
        }
        return CSSpellAnimations.ANIMATION_RIGHT_HORIZONTAL_SLASH;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.DIVINE_SMITE_WINDUP.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)CSSoundRegistry.ELECTRIC_SWORD_SWING.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 300, castSource, null), playerMagicData);
        }
        float radius = 3.25f;
        float distance = 2.2f;
        Vec3 hitLocation = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.3f), 0.0).m_82549_(entity.m_20156_().m_82542_((double)distance, (double)0.35f, (double)distance));
        List entities = entity.m_9236_().m_45933_((Entity)entity, AABB.m_165882_((Vec3)hitLocation, (double)(radius * 2.0f), (double)radius, (double)(radius * 2.0f)));
        for (Entity target : entities) {
            if (!entity.m_6087_() || !(entity.m_20280_(target) < (double)(radius * radius)) || !Utils.hasLineOfSight((Level)level, (Vec3)entity.m_146892_(), (Vec3)target.m_20191_().m_82399_(), (boolean)true) || !DamageSources.applyDamage((Entity)target, (float)(this.getDamage(spellLevel, entity) + this.getBonusDamage(spellLevel, entity)), (DamageSource)this.getDamageSource((Entity)entity))) continue;
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.BLOOD, (double)target.m_20185_(), (double)(target.m_20186_() + (double)(target.m_20206_() * 0.5f)), (double)target.m_20189_(), (int)50, (double)(target.m_20205_() * 0.5f), (double)(target.m_20206_() * 0.5f), (double)(target.m_20205_() * 0.5f), (double)0.03, (boolean)false);
            EnchantmentHelper.m_44896_((LivingEntity)entity, (Entity)target);
        }
        System.out.println("Recasts remaining: " + playerMagicData.getPlayerRecasts().getRemainingRecastsForSpell(this.spellId.toString()));
        this.mirrored = playerMagicData.getPlayerRecasts().getRemainingRecastsForSpell(this.spellId.toString()) % 2 == 0;
        QuickStrikeAoE swipe = new QuickStrikeAoE(level, this.mirrored);
        swipe.m_20219_(hitLocation);
        swipe.m_146922_(entity.m_146908_());
        swipe.setEffectDuration(this.getEffectDuration(spellLevel, entity));
        swipe.setEffectAmplifier(spellLevel);
        level.m_7967_((Entity)swipe);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setIFrames(0).setLifestealPercent(0.35f);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) / 1.5f + Utils.getWeaponDamage((LivingEntity)entity, (MobType)MobType.f_21640_);
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        return this.getRecastCount(spellLevel, caster);
    }

    private float getEffectDuration(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }

    private String getDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float weaponDamage = Utils.getWeaponDamage((LivingEntity)caster, (MobType)MobType.f_21640_);
            String plus = "";
            if (weaponDamage > 0.0f) {
                plus = String.format(" (+%s)", Utils.stringTruncation((double)weaponDamage, (int)1));
            }
            String damage = Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
            return damage + plus;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }
}

