/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.spells.flash_bang;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSSchoolRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FlashBangProjectileEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected int effectDuration;

    public FlashBangProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(false);
    }

    public FlashBangProjectileEntity(Level level, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)CSEntityRegistry.FLASH_BANG_PROJECTILE.get()), level);
        this.m_5602_((Entity)shooter);
    }

    public boolean m_20068_() {
        return false;
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        int count = Mth.m_14045_((int)((int)(vec3.m_82556_() * 4.0)), (int)1, (int)4);
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3((double)0.25);
            float f = (float)i / (float)count;
            double x = Mth.m_14139_((double)f, (double)d0, (double)this.m_20185_());
            double y = Mth.m_14139_((double)f, (double)d1, (double)this.m_20186_());
            double z = Mth.m_14139_((double)f, (double)d2, (double)this.m_20189_());
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, x - random.f_82479_, y + 0.5 - random.f_82480_, z - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
            this.m_9236_().m_7106_(ParticleHelper.EMBERS, x - random.f_82479_, y + 0.5 - random.f_82480_, z - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
        }
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123778_, (double)x, (double)y, (double)z, (int)15, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (boolean)true);
    }

    public float getSpeed() {
        return 1.15f;
    }

    public Optional<Supplier<SoundEvent>> getImpactSound() {
        return Optional.of(() -> SoundEvents.f_11913_);
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
        if (!this.m_9236_().f_46443_) {
            this.impactParticles(this.f_19790_, this.f_19791_, this.f_19792_);
            float radius = this.getExplosionRadius();
            float radiusSqr = radius * radius;
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)radius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.m_9236_(), (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceToSqr = entity.m_20238_(hitresult.m_82450_());
                if (!(distanceToSqr < (double)radiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)losPoint, (Vec3)entity.m_20191_().m_82399_(), (boolean)true)) continue;
                double modifier = 1.0 - distanceToSqr / (double)radiusSqr;
                int duration = (int)((double)this.getEffectDuration() * modifier);
                float damage = (float)((double)this.damage * modifier);
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)SpellRegistries.FLASH_BANG.get()).getDamageSource((Entity)this, this.m_19749_()));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, true, true, true));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, duration, 0, true, true, true));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 0, true, true, true));
            }
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)CSSchoolRegistry.TECHNOMANCY.get()).getTargetingColor(), radius * 2.0f), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            this.m_5496_(SoundEvents.f_11913_, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
            this.m_146870_();
        }
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public void setEffectDuration(int amount) {
        this.effectDuration = amount * 20;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.effectDuration = tag.m_128451_("Duration");
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Duration", this.getEffectDuration());
    }
}

