/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.traceability;

import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingRunnable;

public class ThreadRenamingSubmitterScheduler
extends AbstractSubmitterScheduler {
    protected final SubmitterScheduler scheduler;
    protected final String threadName;
    protected final boolean replace;

    public ThreadRenamingSubmitterScheduler(SubmitterScheduler scheduler, String threadName, boolean replace) {
        this.scheduler = scheduler;
        this.threadName = threadName;
        this.replace = replace;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.scheduler.scheduleWithFixedDelay(new ThreadRenamingRunnable(task, this.threadName, this.replace), initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.scheduler.scheduleAtFixedRate(new ThreadRenamingRunnable(task, this.threadName, this.replace), initialDelay, period);
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMillis) {
        this.scheduler.schedule(new ThreadRenamingRunnable(task, this.threadName, this.replace), delayInMillis);
    }
}

