/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.priority;

import java.util.concurrent.Callable;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.util.ArgumentVerifier;

public class DefaultPriorityWrapper
implements PrioritySchedulerService {
    protected final PrioritySchedulerService scheduler;
    protected final TaskPriority defaultPriority;

    public static PrioritySchedulerService ensurePriority(PrioritySchedulerService scheduler, TaskPriority defaultPriority) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        if (defaultPriority == null || scheduler.getDefaultPriority() == defaultPriority) {
            return scheduler;
        }
        return new DefaultPriorityWrapper(scheduler, defaultPriority);
    }

    public DefaultPriorityWrapper(PrioritySchedulerService scheduler, TaskPriority defaultPriority) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        ArgumentVerifier.assertNotNull((Object)defaultPriority, "defaultPriority");
        this.scheduler = scheduler;
        this.defaultPriority = defaultPriority;
    }

    @Override
    public void execute(Runnable command) {
        this.scheduler.execute(command, this.defaultPriority);
    }

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        this.scheduler.execute(task, priority);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        return this.scheduler.submit(task, this.defaultPriority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.scheduler.submit(task, result, this.defaultPriority);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task, TaskPriority priority) {
        return this.scheduler.submit(task, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.scheduler.submit(task, result, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.scheduler.submit(task, this.defaultPriority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        return this.scheduler.submit(task, priority);
    }

    @Override
    public void schedule(Runnable task, long delayInMs) {
        this.scheduler.schedule(task, delayInMs, this.defaultPriority);
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        this.scheduler.schedule(task, delayInMs, priority);
    }

    @Override
    public ListenableFuture<?> submitScheduled(Runnable task, long delayInMs) {
        return this.scheduler.submitScheduled(task, delayInMs, this.defaultPriority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs) {
        return this.scheduler.submitScheduled(task, result, delayInMs, this.defaultPriority);
    }

    @Override
    public ListenableFuture<?> submitScheduled(Runnable task, long delayInMs, TaskPriority priority) {
        return this.scheduler.submitScheduled(task, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.scheduler.submitScheduled(task, result, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs) {
        return this.scheduler.submitScheduled(task, delayInMs, this.defaultPriority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        return this.scheduler.submitScheduled(task, delayInMs, priority);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.scheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay, this.defaultPriority);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.scheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.scheduler.scheduleAtFixedRate(task, initialDelay, period, this.defaultPriority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.scheduler.scheduleAtFixedRate(task, initialDelay, period, priority);
    }

    @Override
    public boolean remove(Runnable task) {
        return this.scheduler.remove(task);
    }

    @Override
    public boolean remove(Callable<?> task) {
        return this.scheduler.remove(task);
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return this.scheduler.getMaxWaitForLowPriority();
    }

    @Override
    public int getActiveTaskCount() {
        return this.scheduler.getActiveTaskCount();
    }

    @Override
    public int getQueuedTaskCount() {
        return this.scheduler.getQueuedTaskCount();
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return this.scheduler.getQueuedTaskCount(priority);
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        return this.scheduler.getWaitingForExecutionTaskCount();
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        return this.scheduler.getWaitingForExecutionTaskCount(priority);
    }
}

