/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.concurrent.wrapper.limiter.SubmitterSchedulerQueueLimitRejector;

public class SchedulerServiceQueueLimitRejector
extends SubmitterSchedulerQueueLimitRejector
implements SchedulerService {
    protected final SchedulerService parentScheduler;

    public SchedulerServiceQueueLimitRejector(SchedulerService parentScheduler, int queuedTaskLimit) {
        this(parentScheduler, queuedTaskLimit, null);
    }

    public SchedulerServiceQueueLimitRejector(SchedulerService parentScheduler, int queuedTaskLimit, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parentScheduler, queuedTaskLimit, rejectedExecutionHandler);
        this.parentScheduler = parentScheduler;
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        return this.parentScheduler.getWaitingForExecutionTaskCount();
    }

    @Override
    public boolean remove(Runnable task) {
        if (this.parentScheduler.remove(task)) {
            this.queuedTaskCount.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Callable<?> task) {
        if (this.parentScheduler.remove(task)) {
            this.queuedTaskCount.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public int getActiveTaskCount() {
        return this.parentScheduler.getActiveTaskCount();
    }

    @Override
    public boolean isShutdown() {
        return this.parentScheduler.isShutdown();
    }
}

