/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.threadly.concurrent.DoNothingRunnable;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ImmediateResultListenableFuture;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;

public class RateLimiterExecutor
implements SubmitterExecutor {
    protected final SubmitterScheduler scheduler;
    protected final RejectedExecutionHandler rejectedExecutionHandler;
    protected volatile double permitsPerSecond;
    protected volatile long maxScheduleDelayMillis;
    private final AtomicLong lastScheduleTime;

    public RateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond) {
        this(scheduler, permitsPerSecond, Long.MAX_VALUE);
    }

    public RateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis) {
        this(scheduler, permitsPerSecond, maxScheduleDelayMillis, null);
    }

    public RateLimiterExecutor(SubmitterScheduler scheduler, double permitsPerSecond, long maxScheduleDelayMillis, RejectedExecutionHandler rejectedExecutionHandler) {
        ArgumentVerifier.assertNotNull(scheduler, "scheduler");
        this.scheduler = scheduler;
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = RejectedExecutionHandler.THROW_REJECTED_EXECUTION_EXCEPTION;
        }
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.lastScheduleTime = new AtomicLong(Double.doubleToRawLongBits(Clock.lastKnownForwardProgressingMillis()));
        this.setPermitsPerSecond(permitsPerSecond);
        this.setMaxScheduleDelayMillis(maxScheduleDelayMillis);
    }

    public void setPermitsPerSecond(double permitsPerSecond) {
        ArgumentVerifier.assertGreaterThanZero(permitsPerSecond, "permitsPerSecond");
        this.permitsPerSecond = permitsPerSecond;
    }

    public void setMaxScheduleDelayMillis(long maxScheduleDelayMillis) {
        ArgumentVerifier.assertGreaterThanZero(maxScheduleDelayMillis, "maxScheduleDelayMillis");
        this.maxScheduleDelayMillis = maxScheduleDelayMillis;
    }

    public int getMinimumDelay() {
        long delayMillis = this.getLastScheduleTime() - Clock.lastKnownForwardProgressingMillis();
        if (delayMillis < 0L) {
            return 0;
        }
        return (int)delayMillis;
    }

    protected long getLastScheduleTime() {
        return (long)Math.ceil(Double.longBitsToDouble(this.lastScheduleTime.get()));
    }

    public ListenableFuture<?> getFutureTillDelay(long maximumDelay) {
        int currentMinimumDelay = this.getMinimumDelay();
        if (currentMinimumDelay == 0) {
            return ImmediateResultListenableFuture.NULL_RESULT;
        }
        ListenableFutureTask<Object> lft = new ListenableFutureTask<Object>(DoNothingRunnable.instance(), null, this);
        long futureDelay = maximumDelay > 0L && (long)currentMinimumDelay > maximumDelay ? maximumDelay : (long)currentMinimumDelay;
        this.scheduler.schedule(lft, futureDelay);
        return lft;
    }

    @Override
    public void execute(Runnable task) {
        this.execute(1.0, task);
    }

    public long execute(double permits, Runnable task) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(permits, "permits");
        if (task == DoNothingRunnable.instance()) {
            long result = this.taskDelayForPermits(permits);
            if (result < 0L) {
                this.rejectedExecutionHandler.handleRejectedTask(task);
            }
            return result;
        }
        return this.doExecute(permits, task);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.submit(1.0, task, result);
    }

    public ListenableFuture<?> submit(double permits, Runnable task) {
        return this.submit(permits, task, null);
    }

    public <T> ListenableFuture<T> submit(double permits, Runnable task, T result) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(permits, "permits");
        if (task == DoNothingRunnable.instance()) {
            long taskDelay = this.taskDelayForPermits(permits);
            if (taskDelay == 0L) {
                return FutureUtils.immediateResultFuture(result);
            }
            ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, result, this);
            if (taskDelay < 0L) {
                this.rejectedExecutionHandler.handleRejectedTask(lft);
            } else {
                this.scheduler.schedule(lft, taskDelay);
            }
            return lft;
        }
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, result, this);
        this.doExecute(permits, lft);
        return lft;
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.submit(1.0, task);
    }

    public <T> ListenableFuture<T> submit(double permits, Callable<T> task) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(permits, "permits");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.doExecute(permits, lft);
        return lft;
    }

    private long taskDelayForPermits(double permits) {
        double scheduleDelay;
        if (permits == 0.0) {
            long lastScheduleTimeLong = (long)Double.longBitsToDouble(this.lastScheduleTime.get());
            if (lastScheduleTimeLong > Clock.lastKnownForwardProgressingMillis()) {
                return Math.max(0L, lastScheduleTimeLong - Clock.accurateForwardProgressingMillis());
            }
            return 0L;
        }
        double effectiveDelay = permits / this.permitsPerSecond * 1000.0;
        long now = Clock.accurateForwardProgressingMillis();
        while (true) {
            long casLong;
            double lastTimeDouble;
            if ((scheduleDelay = (lastTimeDouble = Double.longBitsToDouble(casLong = this.lastScheduleTime.get())) - (double)now) > (double)this.maxScheduleDelayMillis) {
                return -1L;
            }
            if (scheduleDelay <= 0.0) {
                if (!this.lastScheduleTime.weakCompareAndSetVolatile(casLong, Double.doubleToRawLongBits((double)now + effectiveDelay))) continue;
                return 0L;
            }
            if (this.lastScheduleTime.weakCompareAndSetVolatile(casLong, Double.doubleToRawLongBits(lastTimeDouble + effectiveDelay))) break;
        }
        return (long)scheduleDelay;
    }

    protected long doExecute(double permits, Runnable task) {
        long taskDelay = this.taskDelayForPermits(permits);
        if (taskDelay < 0L) {
            this.rejectedExecutionHandler.handleRejectedTask(task);
        } else {
            this.scheduler.schedule(task, taskDelay);
        }
        return taskDelay;
    }
}

