/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Executor;
import org.threadly.concurrent.wrapper.limiter.AbstractKeyedLimiter;
import org.threadly.concurrent.wrapper.limiter.ExecutorLimiter;
import org.threadly.concurrent.wrapper.traceability.ThreadRenamingExecutor;
import org.threadly.util.StringUtils;

public class KeyedExecutorLimiter
extends AbstractKeyedLimiter<ExecutorLimiter> {
    public KeyedExecutorLimiter(Executor executor, int maxConcurrency) {
        this(executor, maxConcurrency, true);
    }

    public KeyedExecutorLimiter(Executor executor, int maxConcurrency, boolean limitFutureListenersExecution) {
        this(executor, maxConcurrency, null, false, limitFutureListenersExecution);
    }

    public KeyedExecutorLimiter(Executor executor, int maxConcurrency, String subPoolName, boolean addKeyToThreadName) {
        this(executor, maxConcurrency, subPoolName, addKeyToThreadName, true);
    }

    public KeyedExecutorLimiter(Executor executor, int maxConcurrency, String subPoolName, boolean addKeyToThreadName, boolean limitFutureListenersExecution) {
        super(executor, maxConcurrency, subPoolName, addKeyToThreadName, limitFutureListenersExecution);
    }

    @Override
    protected ExecutorLimiter makeLimiter(String limiterThreadName) {
        return new ExecutorLimiter(StringUtils.isNullOrEmpty(limiterThreadName) ? this.executor : new ThreadRenamingExecutor(this.executor, limiterThreadName, false), this.getMaxConcurrencyPerKey(), this.limitFutureListenersExecution);
    }
}

