/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.util.ArgumentVerifier;

public class ExecutorQueueLimitRejector
extends AbstractSubmitterExecutor {
    protected final Executor parentExecutor;
    protected final RejectedExecutionHandler rejectedExecutionHandler;
    protected final AtomicInteger queuedTaskCount;
    private volatile int queuedTaskLimit;

    public ExecutorQueueLimitRejector(Executor parentExecutor, int queuedTaskLimit) {
        this(parentExecutor, queuedTaskLimit, null);
    }

    public ExecutorQueueLimitRejector(Executor parentExecutor, int queuedTaskLimit, RejectedExecutionHandler rejectedExecutionHandler) {
        ArgumentVerifier.assertNotNull(parentExecutor, "parentExecutor");
        ArgumentVerifier.assertGreaterThanZero(queuedTaskLimit, "queuedTaskLimit");
        this.parentExecutor = parentExecutor;
        if (rejectedExecutionHandler == null) {
            rejectedExecutionHandler = RejectedExecutionHandler.THROW_REJECTED_EXECUTION_EXCEPTION;
        }
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.queuedTaskCount = new AtomicInteger();
        this.queuedTaskLimit = queuedTaskLimit;
    }

    public int getQueuedTaskCount() {
        return this.queuedTaskCount.get();
    }

    public int getQueueLimit() {
        return this.queuedTaskLimit;
    }

    public void setQueueLimit(int newLimit) {
        this.queuedTaskLimit = newLimit;
    }

    @Override
    protected void doExecute(Runnable task) {
        int casValue;
        do {
            if ((casValue = this.queuedTaskCount.get()) < this.queuedTaskLimit) continue;
            this.rejectedExecutionHandler.handleRejectedTask(task);
            return;
        } while (!this.queuedTaskCount.compareAndSet(casValue, casValue + 1));
        try {
            this.parentExecutor.execute(new DecrementingRunnable(task, this.queuedTaskCount));
        }
        catch (RejectedExecutionException e) {
            this.queuedTaskCount.decrementAndGet();
            throw e;
        }
    }

    protected static class DecrementingRunnable
    implements Runnable,
    RunnableContainer {
        private final Runnable task;
        private final AtomicInteger queuedTaskCount;

        public DecrementingRunnable(Runnable task, AtomicInteger queuedTaskCount) {
            this.task = task;
            this.queuedTaskCount = queuedTaskCount;
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }

        @Override
        public void run() {
            this.queuedTaskCount.decrementAndGet();
            this.task.run();
        }
    }
}

