/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;

public class ExecutorLimiter
implements SubmitterExecutor {
    protected static final boolean DEFAULT_LIMIT_FUTURE_LISTENER_EXECUTION = true;
    protected final Executor executor;
    protected final Queue<RunnableRunnableContainer> waitingTasks;
    protected final boolean limitFutureListenersExecution;
    private final AtomicInteger currentlyRunning;
    private volatile int maxConcurrency;

    public ExecutorLimiter(Executor executor, int maxConcurrency) {
        this(executor, maxConcurrency, true);
    }

    public ExecutorLimiter(Executor executor, int maxConcurrency, boolean limitFutureListenersExecution) {
        this(executor, maxConcurrency, limitFutureListenersExecution, null);
    }

    protected ExecutorLimiter(Executor executor, int maxConcurrency, boolean limitFutureListenersExecution, Queue<RunnableRunnableContainer> waitingTasks) {
        ArgumentVerifier.assertNotNull(executor, "executor");
        ArgumentVerifier.assertGreaterThanZero(maxConcurrency, "maxConcurrency");
        this.executor = executor;
        this.waitingTasks = waitingTasks == null ? new ConcurrentLinkedQueue() : waitingTasks;
        this.limitFutureListenersExecution = limitFutureListenersExecution;
        this.currentlyRunning = new AtomicInteger(0);
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public void execute(Runnable task) {
        ArgumentVerifier.assertNotNull(task, "task");
        this.executeOrQueue(task, null);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.submit(RunnableCallableAdapter.adapt(task, result));
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = this.makeListenableFutureTask(task);
        this.executeOrQueue(lft, lft);
        return lft;
    }

    protected <T> ListenableFutureTask<T> makeListenableFutureTask(Callable<T> task) {
        return new ListenableFutureTask<T>(task, this);
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        ArgumentVerifier.assertGreaterThanZero(maxConcurrency, "maxConcurrency");
        boolean increasing = this.maxConcurrency < maxConcurrency;
        this.maxConcurrency = maxConcurrency;
        if (increasing) {
            this.consumeAvailable();
        }
    }

    public int getUnsubmittedTaskCount() {
        return this.waitingTasks.size();
    }

    protected boolean taskCapacity() {
        int currentValue;
        while ((currentValue = this.currentlyRunning.get()) < this.maxConcurrency) {
            if (!this.currentlyRunning.weakCompareAndSetVolatile(currentValue, currentValue + 1)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeAvailable() {
        if (this.currentlyRunning.get() >= this.maxConcurrency || this.waitingTasks.isEmpty()) {
            return;
        }
        ExecutorLimiter executorLimiter = this;
        synchronized (executorLimiter) {
            while (!this.waitingTasks.isEmpty() && this.taskCapacity()) {
                this.executor.execute(this.waitingTasks.poll());
            }
        }
    }

    protected boolean canRunTask() {
        return this.waitingTasks.isEmpty() && this.taskCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseExecutionLimit() {
        if (!this.waitingTasks.isEmpty()) {
            Runnable nextTask;
            ExecutorLimiter executorLimiter = this;
            synchronized (executorLimiter) {
                nextTask = this.waitingTasks.poll();
            }
            if (nextTask != null) {
                this.executor.execute(nextTask);
                return;
            }
        }
        this.currentlyRunning.decrementAndGet();
        this.consumeAvailable();
    }

    protected void executeOrQueue(Runnable task, ListenableFuture<?> future) {
        if (this.limitFutureListenersExecution || future == null) {
            this.executeOrQueueWrapper(new LimiterRunnableWrapper(task));
        } else {
            future.listener(this::releaseExecutionLimit, SameThreadSubmitterExecutor.instance());
            if (this.canRunTask()) {
                this.executor.execute(task);
            } else {
                this.addToQueue(new TransparentRunnableContainer(task));
            }
        }
    }

    protected void executeOrQueueWrapper(LimiterRunnableWrapper lrw) {
        if (this.canRunTask()) {
            this.executor.execute(lrw);
        } else {
            this.addToQueue(lrw);
        }
    }

    protected void addToQueue(RunnableRunnableContainer lrw) {
        this.waitingTasks.add(lrw);
        this.consumeAvailable();
    }

    protected static class TransparentRunnableContainer
    implements RunnableRunnableContainer {
        protected final Runnable task;

        protected TransparentRunnableContainer(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }

    protected class LimiterRunnableWrapper
    implements RunnableRunnableContainer {
        protected final Runnable runnable;

        public LimiterRunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        protected void doAfterRunTasks() {
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                try {
                    this.doAfterRunTasks();
                }
                finally {
                    ExecutorLimiter.this.releaseExecutionLimit();
                }
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.runnable;
        }
    }

    protected static interface RunnableRunnableContainer
    extends RunnableContainer,
    Runnable {
    }
}

