/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.SingleThreadScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.statistics.NoThreadSchedulerStatisticTracker;
import org.threadly.concurrent.statistics.PriorityStatisticManager;
import org.threadly.concurrent.statistics.StatisticPriorityScheduler;
import org.threadly.util.Pair;

public class SingleThreadSchedulerStatisticTracker
extends SingleThreadScheduler
implements StatisticPriorityScheduler {
    private final NoThreadSchedulerStatisticTracker statisticTracker;

    public SingleThreadSchedulerStatisticTracker() {
        this((TaskPriority)null, 500L);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        this(defaultPriority, maxWaitForLowPriorityInMs, true);
    }

    public SingleThreadSchedulerStatisticTracker(boolean daemonThread) {
        this((TaskPriority)null, 500L, daemonThread);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean daemonThread) {
        this(defaultPriority, maxWaitForLowPriorityInMs, daemonThread, 1000);
    }

    public SingleThreadSchedulerStatisticTracker(ThreadFactory threadFactory) {
        this(null, 500L, threadFactory);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory) {
        this(defaultPriority, maxWaitForLowPriorityInMs, threadFactory, 1000);
    }

    public SingleThreadSchedulerStatisticTracker(int maxStatisticWindowSize) {
        this(null, 500L, maxStatisticWindowSize);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, int maxStatisticWindowSize) {
        this(defaultPriority, maxWaitForLowPriorityInMs, true, maxStatisticWindowSize);
    }

    public SingleThreadSchedulerStatisticTracker(boolean daemonThread, int maxStatisticWindowSize) {
        this(null, 500L, daemonThread, maxStatisticWindowSize);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean daemonThread, int maxStatisticWindowSize) {
        this(defaultPriority, maxWaitForLowPriorityInMs, daemonThread, maxStatisticWindowSize, false);
    }

    public SingleThreadSchedulerStatisticTracker(ThreadFactory threadFactory, int maxStatisticWindowSize) {
        this(null, 500L, threadFactory, maxStatisticWindowSize);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory, int maxStatisticWindowSize) {
        this(defaultPriority, maxWaitForLowPriorityInMs, threadFactory, maxStatisticWindowSize, false);
    }

    public SingleThreadSchedulerStatisticTracker(int maxStatisticWindowSize, boolean accurateTime) {
        this(null, 500L, maxStatisticWindowSize, accurateTime);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, int maxStatisticWindowSize, boolean accurateTime) {
        this(defaultPriority, maxWaitForLowPriorityInMs, true, maxStatisticWindowSize, accurateTime);
    }

    public SingleThreadSchedulerStatisticTracker(boolean daemonThread, int maxStatisticWindowSize, boolean accurateTime) {
        this(null, 500L, daemonThread, maxStatisticWindowSize, accurateTime);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean daemonThread, int maxStatisticWindowSize, boolean accurateTime) {
        this(defaultPriority, maxWaitForLowPriorityInMs, new ConfigurableThreadFactory(SingleThreadScheduler.class.getSimpleName() + "-", true, daemonThread, 5, null, null, null), maxStatisticWindowSize, accurateTime);
    }

    public SingleThreadSchedulerStatisticTracker(ThreadFactory threadFactory, int maxStatisticWindowSize, boolean accurateTime) {
        this(null, 500L, threadFactory, maxStatisticWindowSize, accurateTime);
    }

    public SingleThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory, int maxStatisticWindowSize, boolean accurateTime) {
        super(defaultPriority, new StatisticTrackerSchedulerManager(defaultPriority, maxWaitForLowPriorityInMs, threadFactory, maxStatisticWindowSize, accurateTime));
        this.statisticTracker = ((StatisticTrackerSchedulerManager)this.sManager).getStatisticTracker();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> wrappedRunnables = super.shutdownNow();
        ArrayList<Runnable> result = new ArrayList<Runnable>(wrappedRunnables.size());
        for (Runnable r : wrappedRunnables) {
            if (r instanceof PriorityStatisticManager.TaskStatWrapper) {
                PriorityStatisticManager.TaskStatWrapper tw = (PriorityStatisticManager.TaskStatWrapper)r;
                if (tw.task instanceof Future && ((Future)((Object)tw.task)).isCancelled()) continue;
                result.add(tw.task);
                continue;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public List<Long> getExecutionDelaySamples() {
        return this.statisticTracker.getExecutionDelaySamples();
    }

    @Override
    public List<Long> getExecutionDelaySamples(TaskPriority priority) {
        return this.statisticTracker.getExecutionDelaySamples(priority);
    }

    @Override
    public double getAverageExecutionDelay() {
        return this.statisticTracker.getAverageExecutionDelay();
    }

    @Override
    public double getAverageExecutionDelay(TaskPriority priority) {
        return this.statisticTracker.getAverageExecutionDelay(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(double ... percentiles) {
        return this.statisticTracker.getExecutionDelayPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statisticTracker.getExecutionDelayPercentiles(priority, percentiles);
    }

    @Override
    public List<Long> getExecutionDurationSamples() {
        return this.statisticTracker.getExecutionDurationSamples();
    }

    @Override
    public List<Long> getExecutionDurationSamples(TaskPriority priority) {
        return this.statisticTracker.getExecutionDurationSamples(priority);
    }

    @Override
    public double getAverageExecutionDuration() {
        return this.statisticTracker.getAverageExecutionDuration();
    }

    @Override
    public double getAverageExecutionDuration(TaskPriority priority) {
        return this.statisticTracker.getAverageExecutionDuration(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(double ... percentiles) {
        return this.statisticTracker.getExecutionDurationPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statisticTracker.getExecutionDurationPercentiles(priority, percentiles);
    }

    @Override
    public List<Pair<Runnable, StackTraceElement[]>> getLongRunningTasks(long durationLimitMillis) {
        return this.statisticTracker.getLongRunningTasks(durationLimitMillis);
    }

    @Override
    public int getLongRunningTasksQty(long durationLimitMillis) {
        return this.statisticTracker.getLongRunningTasksQty(durationLimitMillis);
    }

    @Override
    public void resetCollectedStats() {
        this.statisticTracker.resetCollectedStats();
    }

    @Override
    public long getTotalExecutionCount() {
        return this.statisticTracker.getTotalExecutionCount();
    }

    @Override
    public long getTotalExecutionCount(TaskPriority priority) {
        return this.statisticTracker.getTotalExecutionCount(priority);
    }

    protected static class StatisticTrackerSchedulerManager
    extends SingleThreadScheduler.SchedulerManager {
        public StatisticTrackerSchedulerManager(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory, int maxStatisticWindowSize, boolean accurateTime) {
            super(new NoThreadSchedulerStatisticTracker(defaultPriority, maxWaitForLowPriorityInMs, maxStatisticWindowSize, accurateTime), threadFactory);
        }

        public NoThreadSchedulerStatisticTracker getStatisticTracker() {
            return (NoThreadSchedulerStatisticTracker)this.scheduler;
        }
    }
}

