/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.ConfigurableThreadFactory;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.concurrent.statistics.PriorityStatisticManager;
import org.threadly.concurrent.statistics.StatisticPriorityScheduler;
import org.threadly.util.Clock;
import org.threadly.util.Pair;

public class PrioritySchedulerStatisticTracker
extends PriorityScheduler
implements StatisticPriorityScheduler {
    protected final PriorityStatisticManager statsManager;

    public PrioritySchedulerStatisticTracker(int poolSize) {
        this(poolSize, DEFAULT_PRIORITY, 500L, true);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, boolean useDaemonThreads) {
        this(poolSize, DEFAULT_PRIORITY, 500L, useDaemonThreads);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, true);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean useDaemonThreads) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, useDaemonThreads, 1000, false);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, false, threadFactory);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean stavableStartsThreads, ThreadFactory threadFactory) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, stavableStartsThreads, threadFactory, 1000, false);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, int maxStatisticWindowSize, boolean accurateTime) {
        this(poolSize, DEFAULT_PRIORITY, 500L, true, maxStatisticWindowSize, accurateTime);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, boolean useDaemonThreads, int maxStatisticWindowSize, boolean accurateTime) {
        this(poolSize, DEFAULT_PRIORITY, 500L, useDaemonThreads, maxStatisticWindowSize, accurateTime);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, int maxStatisticWindowSize, boolean accurateTime) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, true, maxStatisticWindowSize, accurateTime);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean useDaemonThreads, int maxStatisticWindowSize, boolean accurateTime) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, false, new ConfigurableThreadFactory(PrioritySchedulerStatisticTracker.class.getSimpleName() + "-", true, useDaemonThreads, 5, null, null, null), maxStatisticWindowSize, accurateTime);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, ThreadFactory threadFactory, int maxStatisticWindowSize, boolean accurateTime) {
        this(poolSize, defaultPriority, maxWaitForLowPriorityInMs, false, threadFactory, maxStatisticWindowSize, accurateTime);
    }

    public PrioritySchedulerStatisticTracker(int poolSize, TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, boolean stavableStartsThreads, ThreadFactory threadFactory, int maxStatisticWindowSize, boolean accurateTime) {
        super(new StatisticWorkerPool(threadFactory, poolSize, stavableStartsThreads, new PriorityStatisticManager(maxStatisticWindowSize, accurateTime)), defaultPriority, maxWaitForLowPriorityInMs);
        this.statsManager = ((StatisticWorkerPool)this.workerPool).statsManager;
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> wrappedRunnables = super.shutdownNow();
        ArrayList<Runnable> result = new ArrayList<Runnable>(wrappedRunnables.size());
        for (Runnable r : wrappedRunnables) {
            if (r instanceof PriorityStatisticManager.TaskStatWrapper) {
                PriorityStatisticManager.TaskStatWrapper tw = (PriorityStatisticManager.TaskStatWrapper)r;
                if (tw.task instanceof Future && ((Future)((Object)tw.task)).isCancelled()) continue;
                result.add(tw.task);
                continue;
            }
            result.add(r);
        }
        return result;
    }

    private Runnable wrap(Runnable task, TaskPriority priority) {
        if (task == null) {
            return null;
        }
        return new PriorityStatisticManager.TaskStatWrapper(this.statsManager, priority == null ? this.getDefaultPriority() : priority, task);
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        return super.doSchedule(new PriorityStatisticManager.TaskStatWrapper(this.statsManager, priority, task), delayInMillis, priority);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        super.scheduleWithFixedDelay(this.wrap(task, priority), initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        super.scheduleAtFixedRate(this.wrap(task, priority), initialDelay, period, priority);
    }

    @Override
    public List<Long> getExecutionDelaySamples() {
        return this.statsManager.getExecutionDelaySamples();
    }

    @Override
    public List<Long> getExecutionDelaySamples(TaskPriority priority) {
        return this.statsManager.getExecutionDelaySamples(priority);
    }

    @Override
    public double getAverageExecutionDelay() {
        return this.statsManager.getAverageExecutionDelay();
    }

    @Override
    public double getAverageExecutionDelay(TaskPriority priority) {
        return this.statsManager.getAverageExecutionDelay(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(double ... percentiles) {
        return this.statsManager.getExecutionDelayPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statsManager.getExecutionDelayPercentiles(priority, percentiles);
    }

    @Override
    public List<Long> getExecutionDurationSamples() {
        return this.statsManager.getExecutionDurationSamples();
    }

    @Override
    public List<Long> getExecutionDurationSamples(TaskPriority priority) {
        return this.statsManager.getExecutionDurationSamples(priority);
    }

    @Override
    public double getAverageExecutionDuration() {
        return this.statsManager.getAverageExecutionDuration();
    }

    @Override
    public double getAverageExecutionDuration(TaskPriority priority) {
        return this.statsManager.getAverageExecutionDuration(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(double ... percentiles) {
        return this.statsManager.getExecutionDurationPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statsManager.getExecutionDurationPercentiles(priority, percentiles);
    }

    @Override
    public List<Pair<Runnable, StackTraceElement[]>> getLongRunningTasks(long durationLimitMillis) {
        return this.statsManager.getLongRunningTasks(durationLimitMillis);
    }

    @Override
    public int getLongRunningTasksQty(long durationLimitMillis) {
        return this.statsManager.getLongRunningTasksQty(durationLimitMillis);
    }

    @Override
    public void resetCollectedStats() {
        this.statsManager.resetCollectedStats();
    }

    @Override
    public long getTotalExecutionCount() {
        return this.statsManager.getTotalExecutionCount();
    }

    @Override
    public long getTotalExecutionCount(TaskPriority priority) {
        return this.statsManager.getTotalExecutionCount(priority);
    }

    protected static class StatisticWorkerPool
    extends PriorityScheduler.WorkerPool {
        protected final PriorityStatisticManager statsManager;

        protected StatisticWorkerPool(ThreadFactory threadFactory, int poolSize, boolean stavableStartsThreads, PriorityStatisticManager statsManager) {
            super(threadFactory, poolSize, stavableStartsThreads);
            this.statsManager = statsManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractPriorityScheduler.TaskWrapper workerIdle(PriorityScheduler.Worker worker) {
            AbstractPriorityScheduler.TaskWrapper result = super.workerIdle(worker);
            if (result != null && result.getContainedRunnable() instanceof PriorityStatisticManager.TaskStatWrapper) {
                long taskDelay = Clock.lastKnownForwardProgressingMillis() - result.getPureRunTime();
                PriorityStatisticManager.TaskStatWrapper statWrapper = (PriorityStatisticManager.TaskStatWrapper)result.getContainedRunnable();
                ConcurrentArrayList<Long> priorityStats = this.statsManager.getExecutionDelaySamplesInternal(statWrapper.priority);
                Object object = priorityStats.getModificationLock();
                synchronized (object) {
                    priorityStats.add(taskDelay);
                    this.statsManager.trimWindow(priorityStats);
                }
            }
            return result;
        }
    }
}

