/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.StackSuppressedRuntimeException;

public class CancelDebuggingListenableFuture<T>
implements ListenableFuture<T> {
    private final ListenableFuture<T> delegateFuture;
    private StackTraceElement[] cancelStack;

    public CancelDebuggingListenableFuture(ListenableFuture<T> delegateFuture) {
        ArgumentVerifier.assertNotNull(delegateFuture, "delegateFuture");
        this.delegateFuture = delegateFuture;
        this.cancelStack = null;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        StackTraceElement[] cancelStack = this.delegateFuture.getRunningStackTrace();
        if (this.delegateFuture.cancel(interrupt)) {
            this.cancelStack = cancelStack;
            return true;
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.delegateFuture.get();
        }
        catch (CancellationException e) {
            this.prepareCancellationException(e);
            throw e;
        }
    }

    @Override
    public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)this.delegateFuture.get(arg0, arg1);
        }
        catch (CancellationException e) {
            this.prepareCancellationException(e);
            throw e;
        }
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        Throwable result = this.delegateFuture.getFailure();
        if (result instanceof CancellationException) {
            this.prepareCancellationException(result);
        }
        return result;
    }

    @Override
    public Throwable getFailure(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Throwable result = this.delegateFuture.getFailure(timeout, unit);
        if (result instanceof CancellationException) {
            this.prepareCancellationException(result);
        }
        return result;
    }

    private void prepareCancellationException(Throwable t) {
        if (this.cancelStack != null) {
            Throwable rootCause = ExceptionUtils.getRootCause(t);
            rootCause.initCause(new FutureProcessingStack(this.cancelStack));
        }
    }

    @Override
    public boolean isCancelled() {
        return this.delegateFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegateFuture.isDone();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.delegateFuture.isCompletedExceptionally();
    }

    @Override
    public ListenableFuture<T> listener(Runnable listener, Executor executor, ListenableFuture.ListenerOptimizationStrategy optimizeExecution) {
        this.delegateFuture.listener(listener, executor, optimizeExecution);
        return this;
    }

    @Override
    public StackTraceElement[] getRunningStackTrace() {
        return this.delegateFuture.getRunningStackTrace();
    }

    public static class FutureProcessingStack
    extends StackSuppressedRuntimeException {
        private static final long serialVersionUID = 5326874345871027481L;

        protected FutureProcessingStack(StackTraceElement[] cancelStack) {
            this.setStackTrace(cancelStack);
        }
    }
}

