/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.ability.base;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.client.screen.utils.ScreenUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public abstract class AbstractActionWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final PacketRelicTweak.Operation operation;
    private final IRelicScreenProvider provider;
    private final String ability;

    public AbstractActionWidget(int x, int y, PacketRelicTweak.Operation operation, AbilityDescriptionScreen screen, String ability) {
        super(x, y, 14, 13);
        this.operation = operation;
        this.provider = screen;
        this.ability = ability;
    }

    @Override
    public abstract boolean isLocked();

    @Override
    public void m_5691_() {
        if (!this.isLocked()) {
            NetworkHandler.sendToServer(new PacketRelicTweak(this.provider.getContainer(), this.provider.getSlot(), this.ability, this.operation));
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String actionId = this.operation.toString().toLowerCase(Locale.ROOT);
        guiGraphics.m_280163_(new ResourceLocation("relics", "textures/gui/description/ability/" + actionId + "_button_" + (this.isLocked() ? "inactive" : "active") + ".png"), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        if (this.f_93622_) {
            guiGraphics.m_280163_(DescriptionTextures.ACTION_BUTTON_OUTLINE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.provider.getStack().m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data.getStats().isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int requiredExperience = relic.getRerollRequiredExperience(this.ability);
        int experience = this.MC.f_91074_.f_36079_;
        MutableComponent negativeStatus = Component.m_237115_((String)"tooltip.relics.relic.status.negative").m_130940_(ChatFormatting.RED);
        MutableComponent positiveStatus = Component.m_237115_((String)"tooltip.relics.relic.status.positive").m_130940_(ChatFormatting.GREEN);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"tooltip.relics.relic.reroll.description").m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)" "), Component.m_237110_((String)"tooltip.relics.relic.reroll.cost", (Object[])new Object[]{requiredExperience, requiredExperience > experience ? negativeStatus : positiveStatus})});
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.f_91062_.m_92852_((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 4.5f);
        int renderX = this.m_252754_() + this.f_93618_ + 1;
        int renderY = mouseY - height / 2 - 9;
        ScreenUtils.drawTexturedTooltipBorder(guiGraphics, new ResourceLocation("relics", "textures/gui/tooltip/border/paper.png"), renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.m_280649_(this.MC.f_91062_, entry, (renderX + 9) * 2, (renderY + 9 + yOff) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void onTick() {
        if (this.MC.f_91074_ == null) {
            return;
        }
        RandomSource random = this.MC.f_91074_.m_217043_();
        if (this.m_274382_() && this.MC.f_91074_.f_19797_ % 5 == 0) {
            ParticleStorage.addParticle((Screen)this.provider, new ExperienceParticleData(this.isLocked() ? new Color(100 + random.m_188503_(100), 100 + random.m_188503_(100), 100 + random.m_188503_(100)) : new Color(200 + random.m_188503_(50), 150 + random.m_188503_(100), 0), this.m_252754_() + random.m_188503_(this.f_93618_), this.m_252907_() + random.m_188503_(this.f_93619_ / 4), 1.0f + random.m_188501_() * 0.25f, 50 + random.m_188503_(50)));
        }
    }

    public PacketRelicTweak.Operation getOperation() {
        return this.operation;
    }

    public IRelicScreenProvider getProvider() {
        return this.provider;
    }

    public String getAbility() {
        return this.ability;
    }
}

