/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.client.render;

import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class NodeBossBarRenderer {
    private final String entityTypeKey;
    private final List<Float> hpPercentages;
    private final ResourceLocation noteTexture;
    private final int textureSize;

    public NodeBossBarRenderer(String entityTypeKey, List<Float> hpPercentages, ResourceLocation noteTexture, int textureSize) {
        this.entityTypeKey = entityTypeKey;
        this.hpPercentages = hpPercentages;
        this.noteTexture = noteTexture;
        this.textureSize = textureSize;
    }

    public void renderBossBar(ResourceLocation texture, GuiGraphics guiGraphics, int x, int y, BossEvent bossEvent, CallbackInfo callbackInfo) {
        TranslatableContents translatableContents;
        Component name = bossEvent.m_18861_();
        ComponentContents barContent = name.m_214077_();
        if (barContent instanceof TranslatableContents && (translatableContents = (TranslatableContents)barContent).m_237508_().equals(this.entityTypeKey)) {
            float colorLocation = (float)(bossEvent.m_18862_().ordinal() * 5) * 2.0f;
            guiGraphics.m_280163_(texture, x, y, 0.0f, colorLocation, 182, 5, this.textureSize, this.textureSize);
            int i = (int)(bossEvent.m_142717_() * 183.0f);
            if (i > 0) {
                float progressLocation = (float)(bossEvent.m_18862_().ordinal() * 5 * 2) + 5.0f;
                guiGraphics.m_280163_(texture, x, y, 0.0f, progressLocation, i, 5, this.textureSize, this.textureSize);
            }
            this.renderBossNodes(bossEvent, guiGraphics, x, y);
            callbackInfo.cancel();
        }
    }

    private void renderBossNodes(BossEvent bossEvent, GuiGraphics guiGraphics, int x, int y) {
        int steppedPercentage = (int)(192.0f * MathUtils.roundedStep((float)bossEvent.m_142717_(), this.hpPercentages, (boolean)true)) + 7;
        guiGraphics.m_280163_(this.noteTexture, x - 3, y - 1, 0.0f, 0.0f, steppedPercentage, 7, this.textureSize, this.textureSize);
        int steppedPercentageReverse = 192 - steppedPercentage;
        guiGraphics.m_280163_(this.noteTexture, x - 3 + steppedPercentage, y - 1, (float)steppedPercentage, 7.0f, steppedPercentageReverse, 7, this.textureSize, this.textureSize);
    }
}

