/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.ClientMixinHandler;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.shake.DefaultShake;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@RegisterFDPacket(value="fdlib:default_shake")
public class DefaultShakePacket
extends FDPacket {
    private FDShakeData data;

    public DefaultShakePacket(FDShakeData shakeData) {
        this.data = shakeData;
    }

    public DefaultShakePacket(FriendlyByteBuf buf) {
        this.data = FDShakeData.STREAM_CODEC.fromNetwork(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        FDShakeData.STREAM_CODEC.toNetwork(buf, this.data);
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        ClientMixinHandler.addShake(new DefaultShake(this.data));
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }

    public static void send(ServerLevel level, Vec3 pos, double radius, FDShakeData data) {
        FDPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)radius, (ResourceKey)level.m_46472_())), (Object)new DefaultShakePacket(data));
    }
}

