/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen;

import com.finderfeed.fdlib.systems.screen.FDScreenComponent;
import java.util.function.BiFunction;

public enum Anchor {
    TOP_LEFT((cmp, x) -> x, (cmp, y) -> y),
    TOP_RIGHT((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth()), (cmp, y) -> y),
    BOTTOM_RIGHT((cmp, x) -> x, (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight())),
    BOTTOM_LEFT((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth()), (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight())),
    TOP_CENTER((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth() / 2.0f), (cmp, y) -> y),
    BOTTOM_CENTER((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth() / 2.0f), (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight())),
    RIGHT_CENTER((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth()), (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight() / 2.0f)),
    LEFT_CENTER((cmp, x) -> x, (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight() / 2.0f)),
    CENTER((cmp, x) -> Float.valueOf(x.floatValue() + cmp.getWidth() / 2.0f), (cmp, y) -> Float.valueOf(y.floatValue() + cmp.getHeight() / 2.0f));

    BiFunction<FDScreenComponent, Float, Float> xTransform;
    BiFunction<FDScreenComponent, Float, Float> yTransform;

    private Anchor(BiFunction<FDScreenComponent, Float, Float> xTransform, BiFunction<FDScreenComponent, Float, Float> yTransform) {
        this.xTransform = xTransform;
        this.yTransform = yTransform;
    }

    public float getX(FDScreenComponent component, float x) {
        return this.xTransform.apply(component, Float.valueOf(x)).floatValue();
    }

    public float getY(FDScreenComponent component, float y) {
        return this.yTransform.apply(component, Float.valueOf(y)).floatValue();
    }
}

