/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle.particle_emitter.processors;

import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessor;
import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessorType;
import com.finderfeed.fdlib.systems.particle.particle_emitter.FDEmitterProcessorTypes;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitter;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Random;
import org.joml.Vector4f;

public class CircleSpawnProcessor
implements EmitterProcessor<CircleSpawnProcessor> {
    private static final Random r = new Random();
    private Vec3 direction = new Vec3(0.0, -1.0, 0.0);
    private float minSpeed = 0.0f;
    private float maxSpeed = 0.1f;
    private float radius = 1.0f;
    private Matrix4f mt;

    public CircleSpawnProcessor(Vec3 direction, float minSpeed, float maxSpeed, float radius) {
        this.direction = direction.m_82541_();
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.radius = radius;
    }

    @Override
    public void initEmitter(ParticleEmitter emitter) {
        Matrix4f mt = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations(mt, this.direction);
        this.mt = mt;
    }

    @Override
    public void tickEmitter(ParticleEmitter emitter) {
    }

    @Override
    public void tickParticle(Particle particle) {
    }

    @Override
    public void initParticle(Particle particle) {
        float x = (r.nextFloat() * 2.0f - 1.0f) * this.radius;
        float z = (r.nextFloat() * 2.0f - 1.0f) * this.radius;
        while (x * x + z * z > this.radius * this.radius) {
            x = (r.nextFloat() * 2.0f - 1.0f) * this.radius;
            z = (r.nextFloat() * 2.0f - 1.0f) * this.radius;
        }
        Vector4f pos = this.mt.transform(x, 0.0f, z, 1.0f, new Vector4f());
        float sp = FDMathUtil.lerp(this.minSpeed, this.maxSpeed, r.nextFloat());
        particle.f_107209_ = (double)pos.x + particle.f_107212_;
        particle.f_107210_ = (double)pos.y + particle.f_107213_;
        particle.f_107211_ = (double)pos.z + particle.f_107214_;
        particle.m_107264_((double)pos.x + particle.f_107212_, (double)pos.y + particle.f_107213_, (double)pos.z + particle.f_107214_);
        particle.f_107215_ = this.direction.f_82479_ * (double)sp;
        particle.f_107216_ = this.direction.f_82480_ * (double)sp;
        particle.f_107217_ = this.direction.f_82481_ * (double)sp;
    }

    @Override
    public EmitterProcessorType<CircleSpawnProcessor> type() {
        return FDEmitterProcessorTypes.CIRCLE_SPAWN_PROCESSOR;
    }

    public static class Type
    implements EmitterProcessorType<CircleSpawnProcessor> {
        public static final NetworkCodec<CircleSpawnProcessor> STREAM_CODEC = NetworkCodec.composite(NetworkCodec.VEC3, v -> v.direction, NetworkCodec.FLOAT, v -> Float.valueOf(v.minSpeed), NetworkCodec.FLOAT, v -> Float.valueOf(v.maxSpeed), NetworkCodec.FLOAT, v -> Float.valueOf(v.radius), (direction, minSpeed, maxSpeed, radius) -> new CircleSpawnProcessor((Vec3)direction, minSpeed.floatValue(), maxSpeed.floatValue(), radius.floatValue()));

        @Override
        public NetworkCodec<CircleSpawnProcessor> codec() {
            return STREAM_CODEC;
        }

        @Override
        public ResourceLocation id() {
            return ResourceLocation.m_214293_((String)"fdlib", (String)"circle_spawn_processor");
        }
    }
}

