/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle.particle_emitter;

import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessorType;
import com.finderfeed.fdlib.systems.particle.particle_emitter.FDEmitterProcessorTypes;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitter;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface EmitterProcessor<T extends EmitterProcessor<T>> {
    public static final NetworkCodec<EmitterProcessor<?>> STREAM_CODEC = new NetworkCodec<EmitterProcessor<?>>(){

        @Override
        public void toNetwork(FriendlyByteBuf buf, EmitterProcessor<?> emitter) {
            buf.m_130085_(emitter.type().id());
            EmitterProcessor.hackyEncode(buf, emitter);
        }

        @Override
        public EmitterProcessor<?> fromNetwork(FriendlyByteBuf buf) {
            ResourceLocation location = buf.m_130281_();
            EmitterProcessorType<?> type = FDEmitterProcessorTypes.get(location);
            if (type == null) {
                throw new RuntimeException("Emitter processor type unknown: " + location);
            }
            EmitterProcessor processor = (EmitterProcessor)type.codec().fromNetwork(buf);
            return processor;
        }
    };

    public void initEmitter(ParticleEmitter var1);

    public void tickEmitter(ParticleEmitter var1);

    public void tickParticle(Particle var1);

    public void initParticle(Particle var1);

    public EmitterProcessorType<T> type();

    public static <T extends EmitterProcessor<T>> void hackyEncode(FriendlyByteBuf buf, EmitterProcessor<T> emitterProcessor) {
        emitterProcessor.type().codec().toNetwork(buf, emitterProcessor);
    }
}

