/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.multiblock;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.multiblock.MultiblockShape;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class MultiblockBlock
extends Block {
    public static final BooleanProperty MAIN_BLOCK = BooleanProperty.m_61465_((String)"main_block");
    protected boolean cacheShape = true;
    private MultiblockShape cachedShape = null;
    private Supplier<MultiblockShape> firstTimeShapeGetter;

    public MultiblockBlock(BlockBehaviour.Properties properties, Supplier<MultiblockShape> multiblockShape) {
        super(properties);
        this.firstTimeShapeGetter = multiblockShape;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)MAIN_BLOCK, (Comparable)Boolean.valueOf(true)));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos mainblock = this.findMainBlock(level, pos);
        if (mainblock != null) {
            BlockState mainBlock = level.m_8055_(mainblock);
            Direction direction = (Direction)mainBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            for (Pair<BlockState, BlockPos> pair : this.getMultiblockShape()) {
                BlockPos offset = (BlockPos)pair.second;
                offset = this.rotateBaseOffset(offset, direction);
                BlockPos setpos = mainblock.m_121955_((Vec3i)offset);
                level.m_7731_(setpos, Blocks.f_50016_.m_49966_(), 2);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos setPos = ctx.m_8083_();
        Direction horizontalDirection = ctx.m_8125_();
        BlockState mainstate = (BlockState)this.getMultiblockShape().getMainState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)horizontalDirection);
        for (Pair<BlockState, BlockPos> pair : this.getMultiblockShape()) {
            BlockPos offset = this.rotateBaseOffset((BlockPos)pair.second, horizontalDirection);
            BlockPos pos = setPos.m_121955_((Vec3i)offset);
            BlockState stateAtPos = level.m_8055_(pos);
            if (stateAtPos.m_247087_()) continue;
            return null;
        }
        return mainstate;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state2, boolean idk) {
        super.m_6807_(state, level, pos, state2, idk);
        if (this.isMainBlock(state)) {
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            for (Pair<BlockState, BlockPos> pair : this.getMultiblockShape()) {
                BlockPos offset = (BlockPos)pair.second;
                if (offset.equals((Object)BlockPos.f_121853_)) continue;
                offset = this.rotateBaseOffset(offset, direction);
                BlockState stateToPlace = (BlockState)((BlockState)pair.first).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
                BlockPos setPos = pos.m_121955_((Vec3i)offset);
                level.m_7731_(setPos, stateToPlace, 2);
            }
        }
    }

    public BlockPos findMainBlock(Level level, BlockPos currentPos) {
        BlockState current = level.m_8055_(currentPos);
        if (current.m_60713_((Block)this) && this.isMainBlock(current)) {
            return currentPos;
        }
        int maxDist = this.getMultiblockShape().getMaxDistanceFromMainBlock();
        for (int x = -maxDist; x <= maxDist; ++x) {
            for (int y = -maxDist; y <= maxDist; ++y) {
                for (int z = -maxDist; z <= maxDist; ++z) {
                    BlockPos pos = currentPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_60713_((Block)this) || !this.isMainBlock(state) || !this.getMultiblockShape().isAPartOfShape(current, pos, currentPos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public BlockPos rotateBaseOffset(BlockPos pos, Direction direction) {
        int yRot = -((int)direction.m_122435_());
        Vec3 v = new Vec3((double)pos.m_123341_(), 0.0, (double)pos.m_123343_()).m_82524_((float)Math.toRadians(yRot));
        BlockPos offsetPos = new BlockPos((int)Math.floor(v.f_82479_ + 0.5), pos.m_123342_(), (int)Math.floor(v.f_82481_ + 0.5));
        return offsetPos;
    }

    public BlockPos rotateOffsetBack(BlockPos pos, Direction direction) {
        int yRot = (int)direction.m_122435_();
        Vec3 v = new Vec3((double)pos.m_123341_(), 0.0, (double)pos.m_123343_()).m_82524_((float)Math.toRadians(yRot));
        BlockPos offsetPos = new BlockPos((int)Math.floor(v.f_82479_ + 0.5), pos.m_123342_(), (int)Math.floor(v.f_82481_ + 0.5));
        return offsetPos;
    }

    public boolean isMainBlock(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)MAIN_BLOCK);
    }

    public MultiblockShape getMultiblockShape() {
        if (!this.cacheShape) {
            return this.firstTimeShapeGetter.get();
        }
        if (this.cachedShape == null) {
            this.cachedShape = this.firstTimeShapeGetter.get();
        }
        return this.cachedShape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MAIN_BLOCK});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }
}

