/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes;

import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CameraPos
implements AutoSerializable {
    @SerializableField
    private Vec3 pos;
    @SerializableField
    private float yaw;
    @SerializableField
    private float pitch;
    @SerializableField
    private float roll = 0.0f;

    protected CameraPos() {
    }

    public CameraPos(Vec3 pos, float yaw, float pitch, float roll) {
        this.pos = pos;
        this.yaw = FDMathUtil.convertMCYRotationToNormal(yaw);
        this.pitch = Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f);
        this.roll = roll;
    }

    public CameraPos(Vec3 pos, Vec3 lookDirection) {
        this(pos, FDMathUtil.yRotFromVector(lookDirection.m_82541_()), FDMathUtil.xRotFromVector(lookDirection.m_82541_()), 0.0f);
    }

    public CameraPos(Vec3 pos, Vec3 lookDirection, float roll) {
        this(pos, FDMathUtil.yRotFromVector(lookDirection.m_82541_()), FDMathUtil.xRotFromVector(lookDirection.m_82541_()), roll);
    }

    public Vec3 interpolate(CameraPos next, float p) {
        return new Vec3(FDMathUtil.lerp(this.pos.f_82479_, next.pos.f_82479_, (double)p), FDMathUtil.lerp(this.pos.f_82480_, next.pos.f_82480_, (double)p), FDMathUtil.lerp(this.pos.f_82481_, next.pos.f_82481_, (double)p));
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getPitch() {
        return this.pitch;
    }
}

