/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.config;

import com.finderfeed.fdlib.systems.config.Comment;
import com.finderfeed.fdlib.systems.config.ConfigValue;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.ManualSerializeable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public abstract class ReflectiveJsonConfig
extends JsonConfig {
    private HashMap<Field, Object> defaultValues = new HashMap();

    public ReflectiveJsonConfig(ResourceLocation name) {
        super(name);
    }

    public void memorizeDefaultValues(Class<?> clazz, Object value) {
        for (Field field : clazz.getFields()) {
            if (field.getAnnotation(ConfigValue.class) == null) continue;
            try {
                Object fieldValue = field.get(value);
                this.defaultValues.put(field, field.get(value));
                this.memorizeDefaultValues(field.getType(), fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean parseJson(JsonObject object) {
        return this.processObject(this, object);
    }

    private boolean processObject(Object currentObject, JsonObject json) {
        boolean changesWereMade = false;
        Class<?> clazz = currentObject.getClass();
        Field[] fields = clazz.getFields();
        if (currentObject instanceof ManualSerializeable) {
            ManualSerializeable serializeable = (ManualSerializeable)currentObject;
            changesWereMade = serializeable.process(json);
        }
        for (Field field : fields) {
            if (field.getAnnotation(ConfigValue.class) == null) continue;
            Comment comment = field.getAnnotation(Comment.class);
            if (comment != null && !json.has("_comment_" + field.getName())) {
                changesWereMade = true;
                json.addProperty("_comment_" + field.getName(), comment.value());
            }
            try {
                String fieldName = field.getName();
                if (json.has(fieldName)) {
                    changesWereMade = this.processFieldInJson(field, json, currentObject) || changesWereMade;
                    continue;
                }
                changesWereMade = true;
                this.processFieldNotInJson(field, json, currentObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return changesWereMade;
    }

    private void processFieldNotInJson(Field field, JsonObject json, Object currentObject) throws IllegalAccessException {
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        if (fieldClass.isEnum()) {
            Object en = this.defaultValues.get(field);
            field.set(currentObject, en);
            json.addProperty(fieldName, en.toString());
        } else if (Integer.TYPE.isAssignableFrom(fieldClass)) {
            int data = (Integer)this.defaultValues.get(field);
            field.set(currentObject, data);
            json.addProperty(fieldName, (Number)data);
        } else if (Float.TYPE.isAssignableFrom(fieldClass)) {
            float data = ((Float)this.defaultValues.get(field)).floatValue();
            field.set(currentObject, Float.valueOf(data));
            json.addProperty(fieldName, (Number)Float.valueOf(data));
        } else if (Double.TYPE.isAssignableFrom(fieldClass)) {
            double data = (Double)this.defaultValues.get(field);
            field.set(currentObject, data);
            json.addProperty(fieldName, (Number)data);
        } else if (String.class.isAssignableFrom(fieldClass)) {
            String data = (String)this.defaultValues.get(field);
            field.set(currentObject, data);
            json.addProperty(fieldName, data);
        } else if (Boolean.TYPE.isAssignableFrom(fieldClass)) {
            boolean data = (Boolean)this.defaultValues.get(field);
            field.set(currentObject, data);
            json.addProperty(fieldName, Boolean.valueOf(data));
        } else {
            Object data = this.defaultValues.get(field);
            JsonObject object = new JsonObject();
            this.processObject(data, object);
            json.add(fieldName, (JsonElement)object);
        }
    }

    private boolean processFieldInJson(Field field, JsonObject json, Object currentObject) throws IllegalAccessException {
        boolean changesWereMade = false;
        String fieldName = field.getName();
        Class<?> fieldClass = field.getType();
        JsonElement element = json.get(fieldName);
        if (fieldClass.isEnum()) {
            String data = element.getAsString();
            ?[] enums = fieldClass.getEnumConstants();
            Object val = null;
            for (Object enumValue : enums) {
                String name = enumValue.toString();
                if (!data.equals(name)) continue;
                val = enumValue;
                break;
            }
            if (val != null) {
                field.set(currentObject, val);
            } else {
                Object defaultValue = this.defaultValues.get(field);
                json.addProperty(fieldName, defaultValue.toString());
                field.set(currentObject, defaultValue);
                changesWereMade = true;
            }
        } else if (Integer.TYPE.isAssignableFrom(fieldClass)) {
            try {
                int data = element.getAsInt();
                field.set(currentObject, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                int data = (Integer)this.defaultValues.get(field);
                json.addProperty(fieldName, (Number)data);
                field.set(currentObject, data);
                changesWereMade = true;
            }
        } else if (Float.TYPE.isAssignableFrom(fieldClass)) {
            try {
                float data = element.getAsFloat();
                field.set(currentObject, Float.valueOf(data));
            }
            catch (Exception e) {
                e.printStackTrace();
                float data = ((Float)this.defaultValues.get(field)).floatValue();
                field.set(currentObject, Float.valueOf(data));
                json.addProperty(fieldName, (Number)Float.valueOf(data));
                changesWereMade = true;
            }
        } else if (Double.TYPE.isAssignableFrom(fieldClass)) {
            try {
                double data = element.getAsDouble();
                field.set(currentObject, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                double data = (Double)this.defaultValues.get(field);
                field.set(currentObject, data);
                json.addProperty(fieldName, (Number)data);
                changesWereMade = true;
            }
        } else if (String.class.isAssignableFrom(fieldClass)) {
            try {
                String data = element.getAsString();
                field.set(currentObject, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                String data = (String)this.defaultValues.get(field);
                field.set(currentObject, data);
                json.addProperty(fieldName, data);
                changesWereMade = true;
            }
        } else if (Boolean.TYPE.isAssignableFrom(fieldClass)) {
            try {
                boolean data = element.getAsBoolean();
                field.set(currentObject, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean data = (Boolean)this.defaultValues.get(field);
                field.set(currentObject, data);
                json.addProperty(fieldName, Boolean.valueOf(data));
                changesWereMade = true;
            }
        } else {
            Object fieldValue = field.get(currentObject);
            try {
                JsonObject newObject = element.getAsJsonObject();
                changesWereMade = this.processObject(fieldValue, newObject);
            }
            catch (Exception e) {
                changesWereMade = true;
                JsonObject newObject = new JsonObject();
                this.processObject(fieldValue, newObject);
                json.add(fieldName, (JsonElement)newObject);
            }
        }
        return changesWereMade;
    }
}

