/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.broken_screen_effect;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.systems.broken_screen_effect.ShatteredScreenEffectInstance;
import com.finderfeed.fdlib.systems.broken_screen_effect.ShatteredScreenSettings;
import com.finderfeed.fdlib.systems.post_shaders.FDPostShaderInitializeEvent;
import com.finderfeed.fdlib.systems.post_shaders.FDRenderPostShaderEvent;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fdlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ShatteredScreenEffectHandler
implements IGuiOverlay {
    private static PostChain shatteredScreenShader;
    private static ShatteredScreenEffectInstance currentEffect;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (currentEffect == null) {
            return;
        }
        ShatteredScreenSettings settings = ShatteredScreenEffectHandler.currentEffect.settings;
        ResourceLocation texture = settings.shatteredScreenTexture;
        if (texture.equals((Object)ShatteredScreenSettings.NULL_LOCATION)) {
            return;
        }
        FDRenderUtil.bindTexture(texture);
        float alpha = currentEffect.getCurrentPercent(partialTick);
        Window window = Minecraft.m_91087_().m_91268_();
        float width = window.m_85445_();
        float height = window.m_85446_();
        FDRenderUtil.blitWithBlend(guiGraphics.m_280168_(), 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, alpha);
    }

    public static void setCurrentEffect(ShatteredScreenSettings settings) {
        currentEffect = new ShatteredScreenEffectInstance(settings);
    }

    @SubscribeEvent
    public static void renderShatteredScreen(FDRenderPostShaderEvent.Screen event) {
        if (currentEffect == null || shatteredScreenShader == null) {
            return;
        }
        if (ShatteredScreenEffectHandler.currentEffect.settings.onScreen) {
            float currentStrength = currentEffect.getCurrentPercent(event.getPartialTicks()) * ShatteredScreenEffectHandler.currentEffect.settings.maxOffset;
            FDClientHelpers.setShaderUniform(shatteredScreenShader, "maxOffset", currentStrength);
            FDClientHelpers.setShaderUniform(shatteredScreenShader, "chromaticAbberationStrength", ShatteredScreenEffectHandler.currentEffect.settings.chromaticAbberationStrength);
            shatteredScreenShader.m_110023_(event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void renderLevelShatteredScreen(FDRenderPostShaderEvent.Level event) {
        if (currentEffect == null || shatteredScreenShader == null) {
            return;
        }
        if (!ShatteredScreenEffectHandler.currentEffect.settings.onScreen) {
            float currentStrength = currentEffect.getCurrentPercent(event.getPartialTicks()) * ShatteredScreenEffectHandler.currentEffect.settings.maxOffset;
            FDClientHelpers.setShaderUniform(shatteredScreenShader, "maxOffset", currentStrength);
            FDClientHelpers.setShaderUniform(shatteredScreenShader, "chromaticAbberationStrength", ShatteredScreenEffectHandler.currentEffect.settings.chromaticAbberationStrength);
            shatteredScreenShader.m_110023_(event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (shatteredScreenShader == null || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            ShatteredScreenEffectHandler.tickCurrentEffect();
        }
    }

    private static void tickCurrentEffect() {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        if (currentEffect != null && currentEffect.hasEnded()) {
            currentEffect = null;
        }
        if (currentEffect != null) {
            currentEffect.tick();
        }
    }

    @SubscribeEvent
    public static void onLogoff(ClientPlayerNetworkEvent.LoggingOut event) {
        currentEffect = null;
    }

    @SubscribeEvent
    public static void registerShader(FDPostShaderInitializeEvent event) {
        event.registerPostChain((textureManager, resourceProvider, renderTarget) -> {
            try {
                return new BrokenScreenPostChain(textureManager, resourceProvider, renderTarget, FDLib.location("shaders/post/shattered_screen.json"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, chain -> {
            shatteredScreenShader = chain;
        });
    }

    public static class BrokenScreenPostChain
    extends PostChain {
        public BrokenScreenPostChain(TextureManager p_110018_, ResourceManager p_330592_, RenderTarget p_110020_, ResourceLocation p_110021_) throws IOException, JsonSyntaxException {
            super(p_110018_, p_330592_, p_110020_, p_110021_);
        }

        public void m_110023_(float pticks) {
            ResourceLocation dataTexture = ShatteredScreenEffectHandler.currentEffect.settings.shatteredScreenDataTexture;
            FDRenderUtil.bindTexture(dataTexture);
            int texture = RenderSystem.getShaderTexture((int)0);
            for (PostPass pass : this.f_110009_) {
                EffectInstance effectInstance = pass.m_110074_();
                effectInstance.m_108954_("sampler0", () -> texture);
            }
            super.m_110023_(pticks);
        }
    }
}

