/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.packets;

import com.finderfeed.fdlib.FDClientPacketExecutables;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.TransitionAnimation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.TickerSyncInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:sync_tile_animations")
public class SyncTileAnimationsPacket
extends FDPacket {
    private BlockPos pos;
    private List<TickerSyncInstance> tickers;

    public SyncTileAnimationsPacket(BlockPos pos, Map<String, AnimationTicker> tickers) {
        this.pos = pos;
        this.tickers = new ArrayList<TickerSyncInstance>();
        for (Map.Entry<String, AnimationTicker> entry : tickers.entrySet()) {
            Animation animation = entry.getValue().getAnimation();
            if (animation.isToNullTransition()) continue;
            if (animation.isTransition()) {
                AnimationTicker ticker = new AnimationTicker(entry.getValue());
                ticker.setAnimation(((TransitionAnimation)animation).getTransitionTo());
                this.tickers.add(new TickerSyncInstance(entry.getKey(), ticker));
                continue;
            }
            this.tickers.add(new TickerSyncInstance(entry.getKey(), entry.getValue()));
        }
    }

    public SyncTileAnimationsPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.tickers = new ArrayList<TickerSyncInstance>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.tickers.add(new TickerSyncInstance(buf.m_130277_(), AnimationTicker.NETWORK_CODEC.fromNetwork(buf)));
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.tickers.size());
        for (TickerSyncInstance instance : this.tickers) {
            buf.m_130070_(instance.tickerName());
            AnimationTicker.NETWORK_CODEC.toNetwork(buf, instance.ticker());
        }
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        FDClientPacketExecutables.tileEntitySyncAnimations(this.pos, this.tickers);
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
    }
}

