/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationHandler;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemModelOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRendererOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.animated_item.AnimatedItemStackContext;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.animated_item.EmptyItemStackContext;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class FDModelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public List<FDModel> models;
    public FDModelItemRendererOptions options;

    public FDModelItemRenderer(FDModelItemRendererOptions options) {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.options = options;
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        FDItemAnimationSystem animationSystem;
        AnimatedItemStackContext currentContext = FDItemAnimationHandler.currentRenderedContext;
        if (currentContext != null) {
            animationSystem = FDItemAnimationHandler.getItemAnimationSystem(currentContext);
        } else {
            EmptyItemStackContext emptyContext = new EmptyItemStackContext(stack);
            FDItemAnimationHandler.tellIAmCurrentlyRendering(emptyContext, false);
            animationSystem = FDItemAnimationHandler.getItemAnimationSystem(emptyContext);
        }
        matrices.m_85836_();
        this.initModelsIfNecessary();
        float scale = this.options.scale.apply(displayContext).floatValue();
        if (displayContext == ItemDisplayContext.GUI) {
            translation = this.options.translation.apply(displayContext);
            matrices.m_85837_(0.5 + (double)translation.x, (double)(0.25f + translation.y), 0.5 + (double)translation.z);
            matrices.m_252781_(Axis.f_252529_.m_252977_(35.0f));
            matrices.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            rotation = this.options.rotation.apply(displayContext);
            matrices.m_252781_(Axis.f_252403_.m_252977_(rotation.z));
            matrices.m_252781_(Axis.f_252436_.m_252977_(rotation.y));
            matrices.m_252781_(Axis.f_252529_.m_252977_(rotation.x));
        } else {
            translation = this.options.translation.apply(displayContext);
            if (displayContext == ItemDisplayContext.GROUND) {
                matrices.m_85837_(0.5 + (double)translation.x, 0.3 + (double)translation.y, 0.5 + (double)translation.z);
            } else {
                matrices.m_85837_(0.5 + (double)translation.z, 0.5 + (double)translation.y, 0.5 + (double)translation.x);
            }
            rotation = this.options.rotation.apply(displayContext);
            matrices.m_252781_(Axis.f_252403_.m_252977_(rotation.z));
            matrices.m_252781_(Axis.f_252436_.m_252977_(rotation.y));
            matrices.m_252781_(Axis.f_252529_.m_252977_(rotation.x));
        }
        matrices.m_85841_(scale, scale, scale);
        List<FDItemModelOptions> fdoptions = this.options.fdItemModelOptions;
        for (int i = 0; i < this.models.size(); ++i) {
            FDModel model = this.models.get(i);
            model.resetTransformations();
            animationSystem.applyAnimations(model, FDRenderUtil.tryGetPartialTickIgnorePause());
            FDItemModelOptions option = fdoptions.get(i);
            RenderType renderType = option.getRenderType().renderType(displayContext, stack);
            VertexConsumer vertex = buffer.m_6299_(renderType);
            FDColor color = option.getFdItemColor().color(displayContext, stack);
            model.render(matrices, vertex, packedLight, OverlayTexture.f_118083_, color.r, color.g, color.b, color.a);
        }
        matrices.m_85849_();
        if (this.options.freeItemRenderer != null) {
            this.options.freeItemRenderer.render(stack, displayContext, matrices, buffer, packedLight, packedOverlay);
        }
    }

    private void initModelsIfNecessary() {
        if (this.models == null) {
            this.models = new ArrayList<FDModel>();
            for (FDItemModelOptions sup : this.options.fdItemModelOptions) {
                this.models.add(new FDModel(sup.getModelInfo().get()));
            }
        }
    }

    public static IClientItemExtensions createExtensions(final FDModelItemRendererOptions options) {
        return new IClientItemExtensions(){
            private FDModelItemRenderer renderer;
            {
                this.renderer = new FDModelItemRenderer(options);
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        };
    }
}

