/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.packets;

import com.finderfeed.fdlib.FDClientPacketExecutables;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

@RegisterFDPacket(value="fdlib:entity_start_animation_packet")
public class EntityStartAnimationPacket
extends FDPacket {
    private int entityId;
    private String tickerName;
    private AnimationTicker ticker;

    public EntityStartAnimationPacket(int entityId, String layer, AnimationTicker ticker) {
        Animation animation = ticker.getAnimation();
        if (animation.isTransition() || animation.isToNullTransition()) {
            throw new RuntimeException("Cannot sync transitions! Only registered animations are allowed!");
        }
        this.entityId = entityId;
        this.tickerName = layer;
        this.ticker = ticker;
    }

    public EntityStartAnimationPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.tickerName = buf.m_130277_();
        this.ticker = AnimationTicker.NETWORK_CODEC.fromNetwork(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130070_(this.tickerName);
        AnimationTicker.NETWORK_CODEC.toNetwork(buf, this.ticker);
    }

    @Override
    public void clientAction(Supplier<NetworkEvent.Context> context) {
        FDClientPacketExecutables.entityStartAnimationPacket(this.entityId, this.tickerName, this.ticker);
    }

    @Override
    public void serverAction(Supplier<NetworkEvent.Context> context) {
        System.out.println("Wtf?");
    }
}

