/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head;

import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.ChangeHeadControllerModePacket;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadController;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.IHasHead;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.WantedLookCoordinatesPacket;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraftforge.network.PacketDistributor;

public class HeadControllerContainer<T extends Mob & IHasHead<T>>
extends LookControl {
    private HashMap<String, HeadController<T>> headControllers = new HashMap();
    private Mode mode = Mode.LOOK;
    private T entity;

    public HeadControllerContainer(T entity) {
        super(entity);
        this.entity = entity;
    }

    public HeadControllerContainer<T> addHeadController(FDModel model, String headBone) {
        this.headControllers.put(headBone, new HeadController<T>(this, model, headBone, this.entity));
        return this;
    }

    public void clientTick() {
        for (Map.Entry<String, HeadController<T>> entry : this.headControllers.entrySet()) {
            HeadController<T> value = entry.getValue();
            value.clientTick();
        }
    }

    public HeadController<T> getController(String headBone) {
        return this.headControllers.get(headBone);
    }

    public Mode getControllersMode() {
        return this.mode;
    }

    public void setControllersMode(Mode mode) {
        if (mode != this.mode) {
            Mode old = this.mode;
            this.mode = mode;
            if (!this.entity.m_9236_().f_46443_) {
                FDPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.entity), new ChangeHeadControllerModePacket<T>(this.entity, mode));
                return;
            }
            for (Map.Entry<String, HeadController<T>> entry : this.headControllers.entrySet()) {
                HeadController<T> value = entry.getValue();
                value.onControllerModeChanged(old, mode);
            }
        }
    }

    public void m_24950_(double x, double y, double z, float p_24954_, float p_24955_) {
        if (!this.entity.m_9236_().f_46443_) {
            FDPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.entity), (Object)new WantedLookCoordinatesPacket((Mob)this.entity, x, y, z));
        }
        super.m_24950_(x, y, z, p_24954_, p_24955_);
    }

    public static enum Mode {
        LOOK,
        ANIMATION,
        ANIMATION_AND_LOOK;

    }
}

