/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimatedObject;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadControllerContainer;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelPart;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix3d;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HeadController<T extends Mob & AnimatedObject> {
    private HeadControllerContainer<T> container;
    private FDModel fdModel;
    private T entity;
    private String headBone;
    private float headTransitionSpeed;
    private float currentHeadRotationX = 0.0f;
    private float currentHeadRotationY = 0.0f;
    private float oldHeadRotationX = 0.0f;
    private float oldHeadRotationY = 0.0f;

    public HeadController(HeadControllerContainer<T> container, FDModel model, String headBone, T entity) {
        this.entity = entity;
        this.headBone = headBone;
        this.fdModel = model;
        this.headTransitionSpeed = entity.m_21529_();
        this.container = container;
    }

    public void clientTick() {
        this.oldHeadRotationX = this.currentHeadRotationX;
        this.oldHeadRotationY = this.currentHeadRotationY;
        Vector2f angles = this.getLookAtTargetAngles();
        float maxXRot = this.entity.m_8132_();
        float maxYRot = this.entity.m_8085_();
        float newY = this.getRotation(this.currentHeadRotationY, Mth.m_14036_((float)FDMathUtil.convertMCYRotationToNormal(angles.y), (float)(-maxYRot), (float)maxYRot));
        float newX = this.getRotation(this.currentHeadRotationX, Mth.m_14036_((float)FDMathUtil.convertMCYRotationToNormal(angles.x), (float)(-maxXRot), (float)maxXRot));
        this.currentHeadRotationY = newY;
        this.currentHeadRotationX = newX;
    }

    public void onControllerModeChanged(HeadControllerContainer.Mode oldMode, HeadControllerContainer.Mode newMode) {
        if (newMode == HeadControllerContainer.Mode.LOOK) {
            ((AnimatedObject)this.entity).getAnimationSystem().applyAnimations(this.fdModel, 0.0f);
            FDModelPart part = this.fdModel.getModelPart(this.headBone);
            this.currentHeadRotationX = FDMathUtil.convertMCYRotationToNormal(this.currentHeadRotationX + part.getXRot());
            this.currentHeadRotationY = FDMathUtil.convertMCYRotationToNormal(this.currentHeadRotationY + part.getYRot());
            this.oldHeadRotationX = this.currentHeadRotationX;
            this.oldHeadRotationY = this.currentHeadRotationY;
        }
    }

    private Vector2f getLookAtTargetAngles() {
        if (this.container.getControllersMode() == HeadControllerContainer.Mode.ANIMATION) {
            return new Vector2f();
        }
        AnimationSystem system = ((AnimatedObject)this.entity).getAnimationSystem();
        this.fdModel.resetTransformations();
        system.applyAnimations(this.fdModel, 0.0f);
        float yRot = this.entity.m_146908_();
        this.fdModel.main.addYRot(-yRot);
        FDModelPart head = this.fdModel.getModelPart(this.headBone);
        head.setXRot(head.initRotation.x);
        head.setYRot(head.initRotation.y);
        head.setZRot(head.initRotation.z);
        Matrix4f transform = this.fdModel.getModelPartTransformation(head);
        Vector3f position = transform.transformPosition(new Vector3f());
        Vector3f wposition = position.add((float)this.entity.m_20185_(), (float)this.entity.m_20186_(), (float)this.entity.m_20189_(), new Vector3f());
        Vector3d playerPosition = new Vector3d(this.container.m_24969_(), this.container.m_24970_(), this.container.m_24971_());
        Vector3d between = playerPosition.sub((Vector3fc)wposition, new Vector3d());
        Vector3d axisX = this.floatToDouble(transform.transformDirection(new Vector3f(1.0f, 0.0f, 0.0f))).normalize();
        Vector3d axisY = this.floatToDouble(transform.transformDirection(new Vector3f(0.0f, 1.0f, 0.0f))).normalize();
        Vector3d axisZ = this.floatToDouble(transform.transformDirection(new Vector3f(0.0f, 0.0f, 1.0f))).normalize();
        Vector3d vec = this.fromOtherBasisToEuclidian(axisX, axisY, axisZ, between);
        float verticalAngle = 180.0f + (float)Math.toDegrees(Math.atan2(vec.x, vec.z));
        double a = Math.sqrt(vec.z * vec.z + vec.x * vec.x);
        float horizontalAngle = (float)Math.toDegrees(Math.atan2(vec.y, a));
        return new Vector2f(horizontalAngle, verticalAngle);
    }

    public float getHeadTransitionSpeed() {
        return this.headTransitionSpeed;
    }

    public T getEntity() {
        return this.entity;
    }

    private float getRotation(float currentRotation, float targetY) {
        if (currentRotation >= 0.0f && targetY >= 0.0f || currentRotation < 0.0f && targetY < 0.0f) {
            int direction;
            int n = direction = targetY - currentRotation > 0.0f ? 1 : -1;
            if (currentRotation >= 0.0f) {
                if (direction == 1) {
                    return Mth.m_14036_((float)(currentRotation + this.getHeadTransitionSpeed() * (float)direction), (float)-2.1474836E9f, (float)targetY);
                }
                return Mth.m_14036_((float)(currentRotation + this.getHeadTransitionSpeed() * (float)direction), (float)targetY, (float)2.1474836E9f);
            }
            if (direction == 1) {
                return Mth.m_14036_((float)(currentRotation + this.getHeadTransitionSpeed() * (float)direction), (float)-2.1474836E9f, (float)targetY);
            }
            return Mth.m_14036_((float)(currentRotation + this.getHeadTransitionSpeed() * (float)direction), (float)targetY, (float)2.1474836E9f);
        }
        if (currentRotation < 0.0f) {
            float dist = -currentRotation + targetY;
            if (dist > 180.0f) {
                if ((currentRotation -= this.getHeadTransitionSpeed()) < -180.0f) {
                    return Mth.m_14036_((float)(currentRotation += 360.0f), (float)targetY, (float)2.1474836E9f);
                }
                return Mth.m_14036_((float)currentRotation, (float)-2.1474836E9f, (float)targetY);
            }
            return Mth.m_14036_((float)(currentRotation + this.getHeadTransitionSpeed()), (float)-2.1474836E9f, (float)targetY);
        }
        float dist = -targetY + currentRotation;
        if (dist > 180.0f) {
            if ((currentRotation += this.getHeadTransitionSpeed()) > 180.0f) {
                return Mth.m_14036_((float)(currentRotation -= 360.0f), (float)-2.1474836E9f, (float)targetY);
            }
            return Mth.m_14036_((float)currentRotation, (float)targetY, (float)2.1474836E9f);
        }
        return Mth.m_14036_((float)(currentRotation - this.getHeadTransitionSpeed()), (float)targetY, (float)2.1474836E9f);
    }

    public float getCurrentHeadRotationX() {
        return this.currentHeadRotationX;
    }

    public float getCurrentHeadRotationY() {
        return this.currentHeadRotationY;
    }

    public Vector2f getCurrentHeadAngles(float pticks) {
        return new Vector2f(FDMathUtil.lerpAround(this.oldHeadRotationX, this.currentHeadRotationX, -180.0f, 180.0f, pticks), FDMathUtil.lerpAround(this.oldHeadRotationY, this.currentHeadRotationY, -180.0f, 180.0f, pticks));
    }

    private Vector3d floatToDouble(Vector3f v) {
        return new Vector3d((double)v.x, (double)v.y, (double)v.z);
    }

    private Vector3d fromEuclidianToOtherBasis(Vector3d nbx, Vector3d nby, Vector3d nbz, Vector3d point) {
        Matrix3d matrix3d = new Matrix3d(nbx.x, nbx.y, nbx.z, nby.x, nby.y, nby.z, nbz.x, nbz.y, nbz.z);
        return matrix3d.transform((Vector3dc)point, new Vector3d());
    }

    private Vector3d fromOtherBasisToEuclidian(Vector3d nbx, Vector3d nby, Vector3d nbz, Vector3d point) {
        Matrix3d matrix3d = new Matrix3d(nbx.x, nbx.y, nbx.z, nby.x, nby.y, nby.z, nbz.x, nbz.y, nbz.z).invert();
        return matrix3d.transform((Vector3dc)point, new Vector3d());
    }
}

